/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.kie.kogito.mongodb.DocumentMarshallingException;
import org.kie.kogito.mongodb.DocumentUnmarshallingException;

public class DocumentUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private DocumentUtils() {
    }

    public static ObjectMapper getObjectMapper() {
        return MAPPER;
    }

    public static MongoCollection<Document> getCollection(MongoClient mongoClient, String processId, String dbName) {
        CodecRegistry registry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry()});
        MongoDatabase mongoDatabase = mongoClient.getDatabase(dbName).withCodecRegistry(registry);
        return mongoDatabase.getCollection(processId, Document.class).withCodecRegistry(registry);
    }

    public static byte[] toByteArray(Object object) {
        String json = null;
        try {
            MAPPER.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance);
            json = MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new DocumentMarshallingException(e);
        }
        return json.getBytes();
    }

    public static Object fromByteArray(String dataType, byte[] object) {
        try {
            Class<?> loadClass = Thread.currentThread().getContextClassLoader().loadClass(dataType);
            MAPPER.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance);
            return MAPPER.readValue(new String(object), loadClass);
        }
        catch (JsonProcessingException | ClassNotFoundException e) {
            throw new DocumentUnmarshallingException(e);
        }
    }
}

