/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb.transaction;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import org.kie.kogito.uow.events.UnitOfWorkAbortEvent;
import org.kie.kogito.uow.events.UnitOfWorkEndEvent;
import org.kie.kogito.uow.events.UnitOfWorkEventListener;
import org.kie.kogito.uow.events.UnitOfWorkStartEvent;

public abstract class MongoDBTransactionManager
implements UnitOfWorkEventListener {
    private MongoClient mongoClient;
    private ThreadLocal<ClientSession> clientSessionLocal = new ThreadLocal();

    public MongoDBTransactionManager(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public void onBeforeStartEvent(UnitOfWorkStartEvent event) {
        if (!this.enabled()) {
            return;
        }
        ClientSession clientSession = this.mongoClient.startSession();
        this.clientSessionLocal.set(clientSession);
        TransactionOptions txnOptions = TransactionOptions.builder().readPreference(ReadPreference.primary()).readConcern(ReadConcern.MAJORITY).writeConcern(WriteConcern.MAJORITY).build();
        clientSession.startTransaction(txnOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAfterEndEvent(UnitOfWorkEndEvent event) {
        if (!this.enabled()) {
            return;
        }
        try (ClientSession clientSession = this.getClientSession();){
            clientSession.commitTransaction();
        }
        finally {
            this.clientSessionLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAfterAbortEvent(UnitOfWorkAbortEvent event) {
        if (!this.enabled()) {
            return;
        }
        try (ClientSession clientSession = this.getClientSession();){
            clientSession.abortTransaction();
        }
        finally {
            this.clientSessionLocal.remove();
        }
    }

    public ClientSession getClientSession() {
        return this.clientSessionLocal.get();
    }

    public abstract boolean enabled();
}

