/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb.transaction;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.mongodb.transaction.AbstractTransactionManager;
import org.kie.kogito.testcontainers.KogitoMongoDBContainer;
import org.kie.kogito.uow.events.UnitOfWorkAbortEvent;
import org.kie.kogito.uow.events.UnitOfWorkEndEvent;
import org.kie.kogito.uow.events.UnitOfWorkStartEvent;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class AbstractTransactionManagerIT {
    @Container
    private static KogitoMongoDBContainer mongoDBContainer = new KogitoMongoDBContainer();
    private static MongoClient mongoClient;
    private static final String DOCUMENT_ID = "_id";
    private static final String TEST_KEY = "test";
    private static final int TEST_THREADS = 2;

    @BeforeAll
    public static void setUp() {
        mongoDBContainer.start();
        mongoClient = MongoClients.create((String)mongoDBContainer.getReplicaSetUrl());
    }

    @AfterAll
    public static void tearDown() {
        mongoDBContainer.stop();
    }

    @Test
    void testInsertion() throws InterruptedException, ExecutionException, TimeoutException {
        String testName = "test_insertion";
        MongoDatabase mongoDatabase = mongoClient.getDatabase(testName);
        MongoCollection mongoCollection = mongoDatabase.getCollection(testName);
        mongoCollection.insertOne((Object)new Document().append(DOCUMENT_ID, (Object)"test0"));
        TestTransactionManager transactionManager = new TestTransactionManager(mongoClient);
        String id1 = "test1";
        String value1 = "test1";
        String id2 = "test2";
        String value2 = "test2";
        ExecutorService service = Executors.newFixedThreadPool(2);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        Future<Object> execution1 = service.submit(() -> {
            try {
                transactionManager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
                MongoCollection mongoCollection1 = mongoDatabase.getCollection(testName);
                mongoCollection1.insertOne(transactionManager.getClientSession(), (Object)new Document().append(DOCUMENT_ID, (Object)id1).append(TEST_KEY, (Object)value1));
                Document result1 = (Document)mongoCollection1.find(transactionManager.getClientSession(), Filters.eq((String)DOCUMENT_ID, (Object)id1)).first();
                Assertions.assertThat((Map)result1).isEqualTo((Object)new Document().append(DOCUMENT_ID, (Object)id1).append(TEST_KEY, (Object)value1));
                int size1 = (int)mongoCollection1.countDocuments(transactionManager.getClientSession());
                Assertions.assertThat((int)size1).isEqualTo(2);
            }
            finally {
                latch1.countDown();
                Assertions.assertThat((boolean)latch2.await(10L, TimeUnit.SECONDS)).isTrue();
            }
            transactionManager.onAfterEndEvent(new UnitOfWorkEndEvent(null));
            return null;
        });
        Future<Object> execution2 = service.submit(() -> {
            try {
                transactionManager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
                MongoCollection mongoCollection2 = mongoDatabase.getCollection(testName);
                mongoCollection2.insertOne(transactionManager.getClientSession(), (Object)new Document().append(DOCUMENT_ID, (Object)id2).append(TEST_KEY, (Object)value2));
                Document result2 = (Document)mongoCollection2.find(transactionManager.getClientSession(), Filters.eq((String)DOCUMENT_ID, (Object)id2)).first();
                Assertions.assertThat((Map)result2).isEqualTo((Object)new Document().append(DOCUMENT_ID, (Object)id2).append(TEST_KEY, (Object)value2));
                int size2 = (int)mongoCollection2.countDocuments(transactionManager.getClientSession());
                Assertions.assertThat((int)size2).isEqualTo(2);
            }
            finally {
                latch2.countDown();
                Assertions.assertThat((boolean)latch1.await(10L, TimeUnit.SECONDS)).isTrue();
            }
            transactionManager.onAfterEndEvent(new UnitOfWorkEndEvent(null));
            return null;
        });
        execution1.get(10L, TimeUnit.SECONDS);
        execution2.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((long)mongoCollection.countDocuments()).isEqualTo(3L);
    }

    @Test
    void testDeletionUpdate() throws InterruptedException, ExecutionException, TimeoutException {
        String testName = "test_deletion_update";
        MongoDatabase mongoDatabase = mongoClient.getDatabase(testName);
        MongoCollection mongoCollection = mongoDatabase.getCollection(testName);
        TestTransactionManager transactionManager = new TestTransactionManager(mongoClient);
        String id1 = "test1";
        String value1 = "test1";
        String id2 = "test2";
        String value2 = "test2";
        mongoCollection.insertOne((Object)new Document().append(DOCUMENT_ID, (Object)id1).append(TEST_KEY, (Object)value1));
        mongoCollection.insertOne((Object)new Document().append(DOCUMENT_ID, (Object)id2).append(TEST_KEY, (Object)value2));
        ExecutorService service = Executors.newFixedThreadPool(2);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        Future<Object> execution1 = service.submit(() -> {
            try {
                transactionManager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
                MongoCollection mongoCollection1 = mongoDatabase.getCollection(testName);
                mongoCollection1.deleteOne(transactionManager.getClientSession(), Filters.eq((String)DOCUMENT_ID, (Object)id1));
                ArrayList<Document> values1 = new ArrayList<Document>();
                try (MongoCursor cursor = mongoCollection1.find(transactionManager.getClientSession()).iterator();){
                    while (cursor.hasNext()) {
                        values1.add((Document)cursor.next());
                    }
                    Assertions.assertThat(values1).hasSize(1);
                    Assertions.assertThat((boolean)values1.stream().allMatch(v -> id2.equals(v.get((Object)DOCUMENT_ID).toString()))).isTrue();
                }
                Document value = (Document)mongoCollection1.find(transactionManager.getClientSession(), Filters.eq((String)DOCUMENT_ID, (Object)id2)).first();
                Assertions.assertThat((Map)value).isEqualTo((Object)new Document().append(DOCUMENT_ID, (Object)id2).append(TEST_KEY, (Object)value2));
            }
            finally {
                latch1.countDown();
                Assertions.assertThat((boolean)latch2.await(10L, TimeUnit.SECONDS)).isTrue();
            }
            transactionManager.onAfterEndEvent(new UnitOfWorkEndEvent(null));
            return null;
        });
        Future<Object> execution2 = service.submit(() -> {
            try {
                transactionManager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
                MongoCollection mongoCollection2 = mongoDatabase.getCollection(testName);
                mongoCollection2.replaceOne(transactionManager.getClientSession(), Filters.eq((String)DOCUMENT_ID, (Object)id2), (Object)new Document().append(DOCUMENT_ID, (Object)id2).append(TEST_KEY, (Object)value1));
                Document values2 = (Document)mongoCollection2.find(transactionManager.getClientSession(), Filters.eq((String)DOCUMENT_ID, (Object)id2)).first();
                Assertions.assertThat((Map)values2).isEqualTo((Object)new Document().append(DOCUMENT_ID, (Object)id2).append(TEST_KEY, (Object)value1));
                int size2 = (int)mongoCollection2.countDocuments(transactionManager.getClientSession());
                Assertions.assertThat((int)size2).isEqualTo(2);
            }
            finally {
                latch2.countDown();
                Assertions.assertThat((boolean)latch1.await(10L, TimeUnit.SECONDS)).isTrue();
            }
            transactionManager.onAfterEndEvent(new UnitOfWorkEndEvent(null));
            return null;
        });
        execution1.get(10L, TimeUnit.SECONDS);
        execution2.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((long)mongoCollection.countDocuments()).isOne();
        Assertions.assertThat((String)Objects.requireNonNull((Document)mongoCollection.find(Filters.eq((String)DOCUMENT_ID, (Object)id2)).first()).getString((Object)TEST_KEY)).isEqualTo(value1);
    }

    @Test
    void testAbort() {
        String testName = "test_abort";
        MongoDatabase mongoDatabase = mongoClient.getDatabase(testName);
        MongoCollection mongoCollection = mongoDatabase.getCollection(testName);
        mongoCollection.insertOne((Object)new Document().append(DOCUMENT_ID, (Object)"test0"));
        TestTransactionManager transactionManager = new TestTransactionManager(mongoClient);
        String id1 = "test1";
        String value1 = "test1";
        transactionManager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
        mongoCollection.insertOne(transactionManager.getClientSession(), (Object)new Document().append(DOCUMENT_ID, (Object)id1).append(TEST_KEY, (Object)value1));
        Document result = (Document)mongoCollection.find(transactionManager.getClientSession(), Filters.eq((String)DOCUMENT_ID, (Object)id1)).first();
        Assertions.assertThat((Map)result).isEqualTo((Object)new Document().append(DOCUMENT_ID, (Object)id1).append(TEST_KEY, (Object)value1));
        int size1 = (int)mongoCollection.countDocuments(transactionManager.getClientSession());
        Assertions.assertThat((int)size1).isEqualTo(2);
        int size2 = (int)mongoCollection.countDocuments();
        Assertions.assertThat((int)size2).isOne();
        transactionManager.onAfterAbortEvent(new UnitOfWorkAbortEvent(null));
        int size3 = (int)mongoCollection.countDocuments();
        Assertions.assertThat((int)size3).isOne();
    }

    static class TestTransactionManager
    extends AbstractTransactionManager {
        public TestTransactionManager(MongoClient mongoClient) {
            super(mongoClient, Boolean.valueOf(true));
        }
    }
}

