/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.bson.Document;
import org.drools.io.ClassPathResource;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.serialization.process.MarshallerContextName;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerService;

class DocumentProcessInstanceMarshallerTest {
    ProcessInstanceMarshallerService marshaller = ProcessInstanceMarshallerService.newBuilder().withDefaultObjectMarshallerStrategies().withContextEntries(Collections.singletonMap(MarshallerContextName.MARSHALLER_FORMAT, "json")).build();
    static BpmnProcess process;
    static Document doc;

    DocumentProcessInstanceMarshallerTest() {
    }

    @BeforeAll
    static void setup() throws URISyntaxException, IOException {
        process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.configure();
    }

    @Test
    void testMarshalProcessInstance() {
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "testValue")));
        processInstance.start();
        doc = Document.parse((String)new String(this.marshaller.marshallProcessInstance(processInstance)));
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)doc).as("Marshalled value should not be null", new Object[0])).isNotNull()).containsEntry((Object)"id", (Object)processInstance.id())).containsEntry((Object)"description", (Object)processInstance.description());
        Assertions.assertThat((List)((Document)doc.get((Object)"context", Document.class)).getList((Object)"variable", Document.class)).hasSize(1);
        Assertions.assertThat((Map)((Map)((Document)doc.get((Object)"context", Document.class)).getList((Object)"variable", Document.class).get(0))).containsEntry((Object)"name", (Object)"test");
        Assertions.assertThat((Map)((Map)((Document)((Document)doc.get((Object)"context", Document.class)).getList((Object)"variable", Document.class).get(0)).get((Object)"value", Document.class))).containsEntry((Object)"value", (Object)"testValue");
    }

    @Test
    void testUnmarshalProcessInstance() {
        ProcessInstance processInstance = this.marshaller.unmarshallProcessInstance(doc.toJson().getBytes(), (Process)process);
        ((ObjectAssert)Assertions.assertThat((Object)processInstance).as("Unmarshalled value should not be null", new Object[0])).isNotNull();
        Assertions.assertThat((String)processInstance.id()).isEqualTo(doc.get((Object)"id"));
        ((AbstractStringAssert)Assertions.assertThat((String)processInstance.description()).isEqualTo(doc.get((Object)"description"))).isEqualTo("User Task");
        Collection values = process.instances().values();
        Assertions.assertThat((Collection)values).isNotEmpty();
        BpmnVariables variables = (BpmnVariables)processInstance.variables();
        String testVar = (String)variables.get("test");
        Assertions.assertThat((String)testVar).isEqualTo("testValue");
    }

    @Test
    void testProcessInstanceReadOnly() {
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "testValue")));
        processInstance.start();
        doc = Document.parse((String)new String(this.marshaller.marshallProcessInstance(processInstance)));
        ProcessInstance processInstanceReadOnly = this.marshaller.unmarshallProcessInstance(doc.toJson().getBytes(), (Process)process);
        ((ObjectAssert)Assertions.assertThat((Object)processInstanceReadOnly).as("Unmarshalled value should not be null", new Object[0])).isNotNull();
        ProcessInstance pi = this.marshaller.unmarshallReadOnlyProcessInstance(doc.toJson().getBytes(), (Process)process);
        ((ObjectAssert)Assertions.assertThat((Object)pi).as("Unmarshalled value should not be null", new Object[0])).isNotNull();
    }
}

