/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb;

import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.drools.io.ClassPathResource;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.mongodb.AbstractProcessInstancesFactory;
import org.kie.kogito.mongodb.MongoDBProcessInstances;
import org.kie.kogito.mongodb.TestHelper;
import org.kie.kogito.mongodb.transaction.AbstractTransactionManager;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.test.utils.ProcessInstancesTestUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class PersistentProcessInstancesIT
extends TestHelper {
    PersistentProcessInstancesIT() {
    }

    @Test
    void testMongoDBPersistence() {
        MongoDBProcessInstancesFactory factory = new MongoDBProcessInstancesFactory(PersistentProcessInstancesIT.getMongoClient(), PersistentProcessInstancesIT.getDisabledMongoDBTransactionManager());
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)factory);
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        MongoDBProcessInstances mongodbInstance = new MongoDBProcessInstances(PersistentProcessInstancesIT.getMongoClient(), (Process)process, "testdb", PersistentProcessInstancesIT.getDisabledMongoDBTransactionManager(), false);
        ProcessInstancesTestUtils.assertOne((ProcessInstances)mongodbInstance);
        ProcessInstancesTestUtils.assertOne((ProcessInstances)process.instances());
        Optional findById = mongodbInstance.findById(processInstance.id());
        BpmnProcessInstance found = (BpmnProcessInstance)findById.get();
        ((ObjectAssert)Assertions.assertThat((Object)found).as("ProcessInstanceDocument cannot be null", new Object[0])).isNotNull();
        Assertions.assertThat((String)found.id()).isEqualTo(processInstance.id());
        Assertions.assertThat((String)found.description()).isEqualTo("User Task");
        Assertions.assertThat((Map)((BpmnVariables)found.variables()).toMap()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"test", (Object)"test")});
        Assertions.assertThat((boolean)mongodbInstance.exists(processInstance.id())).isTrue();
        ProcessInstancesTestUtils.assertOne((ProcessInstances)mongodbInstance);
        ProcessInstance readOnlyPI = (ProcessInstance)mongodbInstance.findById(processInstance.id(), ProcessInstanceReadMode.READ_ONLY).get();
        ((ObjectAssert)Assertions.assertThat((Object)readOnlyPI).as("ProcessInstanceDocument cannot be null", new Object[0])).isNotNull();
        Assertions.assertThat((Stream)mongodbInstance.stream(ProcessInstanceReadMode.READ_ONLY)).hasSize(1);
        mongodbInstance.remove(processInstance.id());
        Assertions.assertThat((boolean)mongodbInstance.exists(processInstance.id())).isFalse();
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)mongodbInstance);
    }

    @Test
    void testMongoDBPersistenceWithTransaction() {
        AbstractTransactionManager transactionExecutor = (AbstractTransactionManager)Mockito.mock(AbstractTransactionManager.class);
        ClientSession clientSession = (ClientSession)Mockito.mock(ClientSession.class);
        Mockito.when((Object)transactionExecutor.getClientSession()).thenReturn((Object)clientSession);
        MongoClient mongoClient = (MongoClient)Mockito.mock(MongoClient.class);
        MongoDatabase mongoDatabase = (MongoDatabase)Mockito.mock(MongoDatabase.class);
        MongoCollection mongoCollection = (MongoCollection)Mockito.mock(MongoCollection.class);
        Mockito.when((Object)mongoClient.getDatabase(ArgumentMatchers.anyString())).thenReturn((Object)mongoDatabase);
        Mockito.when((Object)mongoDatabase.withCodecRegistry((CodecRegistry)ArgumentMatchers.any())).thenReturn((Object)mongoDatabase);
        Mockito.when((Object)mongoDatabase.getCollection(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.eq(Document.class))).thenReturn((Object)mongoCollection);
        Mockito.when((Object)mongoCollection.withCodecRegistry((CodecRegistry)ArgumentMatchers.any())).thenReturn((Object)mongoCollection);
        MongoCursor cursor = (MongoCursor)Mockito.mock(MongoCursor.class);
        Mockito.when((Object)cursor.hasNext()).thenReturn((Object)false);
        FindIterable results = (FindIterable)Mockito.mock(FindIterable.class);
        Mockito.when((Object)((Document)results.first())).thenReturn(null);
        Mockito.when((Object)results.iterator()).thenReturn((Object)cursor);
        Mockito.when((Object)mongoCollection.find((ClientSession)ArgumentMatchers.eq((Object)clientSession), (Bson)ArgumentMatchers.any(Bson.class))).thenReturn((Object)results);
        Mockito.when((Object)mongoCollection.find((ClientSession)ArgumentMatchers.eq((Object)clientSession))).thenReturn((Object)results);
        Mockito.when((Object)mongoCollection.find((Bson)ArgumentMatchers.any(Bson.class))).thenReturn((Object)results);
        Mockito.when((Object)mongoCollection.find()).thenReturn((Object)results);
        String id = "testId";
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new MongoDBProcessInstancesFactory(PersistentProcessInstancesIT.getMongoClient(), transactionExecutor));
        process.configure();
        MongoDBProcessInstances mongodbInstance = new MongoDBProcessInstances(mongoClient, (Process)process, "testdb", transactionExecutor, false);
        mongodbInstance.findById(id, ProcessInstanceReadMode.READ_ONLY);
        ((MongoCollection)Mockito.verify((Object)mongoCollection, (VerificationMode)Mockito.times((int)1))).find((ClientSession)ArgumentMatchers.eq((Object)clientSession), (Bson)ArgumentMatchers.eq((Object)Filters.eq((String)"id", (Object)id)));
        mongodbInstance.exists(id);
        ((MongoCollection)Mockito.verify((Object)mongoCollection, (VerificationMode)Mockito.times((int)2))).find((ClientSession)ArgumentMatchers.eq((Object)clientSession), (Bson)ArgumentMatchers.eq((Object)Filters.eq((String)"id", (Object)id)));
        mongodbInstance.remove(id);
        ((MongoCollection)Mockito.verify((Object)mongoCollection, (VerificationMode)Mockito.times((int)1))).deleteOne((ClientSession)ArgumentMatchers.eq((Object)clientSession), (Bson)ArgumentMatchers.eq((Object)Filters.eq((String)"id", (Object)id)));
        WorkflowProcessInstance updatePi = ((AbstractProcessInstance)process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")))).internalGetProcessInstance();
        updatePi.setId(id);
        updatePi.setStartDate(new Date());
        AbstractProcessInstance mockUpdateProcessInstance = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        Mockito.when((Object)mockUpdateProcessInstance.status()).thenReturn((Object)1);
        Mockito.when((Object)mockUpdateProcessInstance.internalGetProcessInstance()).thenReturn((Object)updatePi);
        mongodbInstance.update(id, (ProcessInstance)mockUpdateProcessInstance);
        ((MongoCollection)Mockito.verify((Object)mongoCollection, (VerificationMode)Mockito.times((int)1))).replaceOne((ClientSession)ArgumentMatchers.eq((Object)clientSession), (Bson)ArgumentMatchers.eq((Object)Filters.eq((String)"id", (Object)id)), (Object)((Document)ArgumentMatchers.any()));
        WorkflowProcessInstance createPi = ((AbstractProcessInstance)process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")))).internalGetProcessInstance();
        createPi.setId(id);
        createPi.setStartDate(new Date());
        AbstractProcessInstance mockCreateProcessInstance = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        Mockito.when((Object)mockCreateProcessInstance.status()).thenReturn((Object)1);
        Mockito.when((Object)mockCreateProcessInstance.internalGetProcessInstance()).thenReturn((Object)createPi);
        mongodbInstance.create(id, (ProcessInstance)mockCreateProcessInstance);
        ((MongoCollection)Mockito.verify((Object)mongoCollection, (VerificationMode)Mockito.times((int)1))).insertOne((ClientSession)ArgumentMatchers.eq((Object)clientSession), (Object)((Document)ArgumentMatchers.any()));
    }

    private class MongoDBProcessInstancesFactory
    extends AbstractProcessInstancesFactory {
        public MongoDBProcessInstancesFactory(MongoClient mongoClient, AbstractTransactionManager transactionManager) {
            super(mongoClient, "testdb", Boolean.valueOf(false), transactionManager);
        }
    }
}

