/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.kie.kogito.mongodb.transaction.AbstractTransactionManager;
import org.kie.kogito.testcontainers.KogitoMongoDBContainer;
import org.testcontainers.junit.jupiter.Container;

public class TestHelper {
    @Container
    static final KogitoMongoDBContainer mongoDBContainer = new KogitoMongoDBContainer();
    public static final String DB_NAME = "testdb";
    public static final String PROCESS_NAME = "test";
    private static MongoClient mongoClient;

    @BeforeAll
    public static void startContainerAndPublicPortIsAvailable() {
        mongoDBContainer.start();
        mongoClient = MongoClients.create((String)mongoDBContainer.getReplicaSetUrl());
    }

    @AfterAll
    public static void close() {
        mongoClient.close();
        mongoDBContainer.stop();
    }

    public static MongoClient getMongoClient() {
        return mongoClient;
    }

    public static AbstractTransactionManager getDisabledMongoDBTransactionManager() {
        return new AbstractTransactionManager(mongoClient, false){};
    }
}

