/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.postgresql;

import io.vertx.pgclient.PgPool;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.io.impl.ClassPathResource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.persistence.KogitoProcessInstancesFactory;
import org.kie.kogito.persistence.postgresql.PostgreProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
class PostgreProcessInstancesIT {
    @Container
    static final KogitoPostgreSqlContainer container = new KogitoPostgreSqlContainer();
    private static PgPool client;
    private SecurityPolicy securityPolicy = SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)"john"));

    PostgreProcessInstancesIT() {
    }

    @BeforeAll
    public static void startContainerAndPublicPortIsAvailable() {
        container.start();
        client = PostgreProcessInstancesIT.client();
    }

    @AfterAll
    public static void close() {
        container.stop();
    }

    private BpmnProcess createProcess(ProcessConfig config, String fileName) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((ProcessConfig)config, (Resource[])new Resource[]{new ClassPathResource(fileName)}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new PostgreProcessInstancesFactory(client));
        process.configure();
        process.instances().values(ProcessInstanceReadMode.MUTABLE).forEach(p -> p.abort());
        return process;
    }

    private static PgPool client() {
        return PgPool.pool((String)container.getReactiveUrl());
    }

    @Test
    void testBasicFlow() {
        BpmnProcess process = this.createProcess(null, "BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        PostgreProcessInstances processInstances = (PostgreProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Assertions.assertThat((boolean)processInstances.exists(processInstance.id())).isTrue();
        ProcessInstance readOnlyPI = (ProcessInstance)process.instances().findById(processInstance.id(), ProcessInstanceReadMode.READ_ONLY).get();
        Assertions.assertThat((int)readOnlyPI.status()).isEqualTo(1);
        Assertions.assertThat((int)process.instances().values(ProcessInstanceReadMode.READ_ONLY).size()).isOne();
        ((PostgreProcessInstances)Mockito.verify((Object)processInstances)).create((String)ArgumentMatchers.any(), (ProcessInstance)ArgumentMatchers.any());
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        Assertions.assertThat((List)((ProcessInstance)process.instances().values().iterator().next()).workItems(new Policy[]{this.securityPolicy})).hasSize(1);
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{this.securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat(workItem.getParameters().get("ActorId")).isEqualTo((Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        processInstances = (PostgreProcessInstances)process.instances();
        ((PostgreProcessInstances)Mockito.verify((Object)processInstances, (VerificationMode)Mockito.times((int)2))).remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Iterable)process.instances().values()).isEmpty();
    }

    private class PostgreProcessInstancesFactory
    extends KogitoProcessInstancesFactory {
        public PostgreProcessInstancesFactory(PgPool client) {
            super(client, Boolean.valueOf(true), Long.valueOf(10000L));
        }

        public PostgreProcessInstances createProcessInstances(Process<?> process) {
            PostgreProcessInstances instances = (PostgreProcessInstances)Mockito.spy((Object)super.createProcessInstances(process));
            return instances;
        }

        public boolean lock() {
            return false;
        }
    }
}

