/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence;

import io.vertx.pgclient.PgPool;
import org.kie.kogito.persistence.postgresql.PostgreProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstancesFactory;

public abstract class KogitoProcessInstancesFactory
implements ProcessInstancesFactory {
    private final Long queryTimeout;
    private final PgPool client;
    private final boolean autoDDL;

    protected KogitoProcessInstancesFactory() {
        this(null, true, 10000L);
    }

    public KogitoProcessInstancesFactory(PgPool client, Boolean autoDDL, Long queryTimeout) {
        this.client = client;
        this.autoDDL = autoDDL;
        this.queryTimeout = queryTimeout;
    }

    public PgPool client() {
        return this.client;
    }

    public abstract boolean lock();

    public PostgreProcessInstances createProcessInstances(Process<?> process) {
        return new PostgreProcessInstances(process, this.client(), this.autoDDL, this.queryTimeout, this.lock());
    }
}

