/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlProcessInstances
implements MutableProcessInstances {
    private static final String VERSION = "version";
    private static final String PAYLOAD = "payload";
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresqlProcessInstances.class);
    private final Process<?> process;
    private final PgPool client;
    private final ProcessInstanceMarshallerService marshaller;
    private final boolean autoDDL;
    private final Long queryTimeoutMillis;
    private final boolean lock;

    public PostgresqlProcessInstances(Process<?> process, PgPool client, boolean autoDDL, Long queryTimeoutMillis, boolean lock) {
        this.process = process;
        this.client = client;
        this.autoDDL = autoDDL;
        this.queryTimeoutMillis = queryTimeoutMillis;
        this.marshaller = ProcessInstanceMarshallerService.newBuilder().withDefaultObjectMarshallerStrategies().build();
        this.lock = lock;
        this.init();
    }

    public boolean exists(String id) {
        return this.findById(id).isPresent();
    }

    public void create(String id, ProcessInstance instance) {
        if (!this.isActive(instance)) {
            this.disconnect(instance);
            return;
        }
        this.insertInternal(UUID.fromString(id), this.marshaller.marshallProcessInstance(instance));
    }

    public void update(String id, ProcessInstance instance) {
        if (!this.isActive(instance)) {
            this.disconnect(instance);
            return;
        }
        if (this.lock) {
            this.updateWithLock(UUID.fromString(id), this.marshaller.marshallProcessInstance(instance), instance.version());
        } else {
            this.updateInternal(UUID.fromString(id), this.marshaller.marshallProcessInstance(instance));
        }
        this.disconnect(instance);
    }

    public void remove(String id) {
        boolean isDeleted = this.deleteInternal(UUID.fromString(id));
        if (this.lock && !isDeleted) {
            throw this.uncheckedException(null, "The document with ID: %s was updated or deleted by other request.", id);
        }
    }

    public Optional<ProcessInstance> findById(String id, ProcessInstanceReadMode mode) {
        Optional<byte[]> payload;
        Optional<Row> row = this.findByIdInternal(UUID.fromString(id));
        if (row.isPresent() && (payload = row.map(r -> r.getBuffer(PAYLOAD)).map(Buffer::getBytes)).isPresent()) {
            ProcessInstance instance = mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(payload.get(), this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(payload.get(), this.process);
            ((AbstractProcessInstance)instance).setVersion(row.get().getLong(VERSION).longValue());
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public Collection<ProcessInstance> values(ProcessInstanceReadMode mode) {
        return this.findAllInternal().stream().map(b -> mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(b, this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(b, this.process)).collect(Collectors.toList());
    }

    public Integer size() {
        return this.countInternal().intValue();
    }

    public boolean lock() {
        return this.lock;
    }

    private void disconnect(ProcessInstance instance) {
        Supplier<byte[]> supplier = () -> {
            Optional<Row> row = this.findByIdInternal(UUID.fromString(instance.id()));
            ((AbstractProcessInstance)instance).setVersion(row.get().getLong(VERSION).longValue());
            return row.map(r -> r.getBuffer(PAYLOAD)).map(Buffer::getBytes).get();
        };
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(this.marshaller.createdReloadFunction(supplier));
    }

    private boolean insertInternal(UUID id, byte[] payload) {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("INSERT INTO process_instances (id, payload, process_id, version) VALUES ($1, $2, $3, $4)").execute(Tuple.of((Object)id, (Object)Buffer.buffer((byte[])payload), (Object)this.process.id(), (Object)0L), this.getAsyncResultHandler(future));
            return this.getExecutedResult(future);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.uncheckedException(e, "Error inserting process instance %s", id);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error inserting process instance %s", id);
        }
    }

    private RuntimeException uncheckedException(Exception ex, String message, Object ... param) {
        return new RuntimeException(String.format(message, param), ex);
    }

    private Handler<AsyncResult<RowSet<Row>>> getAsyncResultHandler(CompletableFuture<RowSet<Row>> future) {
        return ar -> {
            if (ar.succeeded()) {
                future.complete((RowSet)ar.result());
            } else {
                future.completeExceptionally(ar.cause());
            }
        };
    }

    private boolean updateInternal(UUID id, byte[] payload) {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("UPDATE process_instances SET payload = $1 WHERE id = $2").execute(Tuple.of((Object)Buffer.buffer((byte[])payload), (Object)id), this.getAsyncResultHandler(future));
            return this.getExecutedResult(future);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.uncheckedException(e, "Error updating process instance %s", id);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error updating process instance %s", id);
        }
    }

    private boolean deleteInternal(UUID id) {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("DELETE FROM process_instances WHERE id = $1").execute(Tuple.of((Object)id), this.getAsyncResultHandler(future));
            return this.getExecutedResult(future);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.uncheckedException(e, "Error deleting process instance %s", id);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error deleting process instance %s", id);
        }
    }

    private Boolean getExecutedResult(CompletableFuture<RowSet<Row>> future) throws ExecutionException, TimeoutException, InterruptedException {
        try {
            return this.getResultFromFuture(future).map(SqlResult::rowCount).map(count -> count == 1).orElse(false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    private Optional<RowSet<Row>> getResultFromFuture(CompletableFuture<RowSet<Row>> future) throws ExecutionException, TimeoutException, InterruptedException {
        try {
            return Optional.ofNullable(future.get(this.queryTimeoutMillis, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    private Optional<Row> findByIdInternal(UUID id) {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("SELECT payload, version FROM process_instances WHERE id = $1").execute(Tuple.of((Object)id), this.getAsyncResultHandler(future));
            return this.getResultFromFuture(future).map(RowSet::iterator).filter(Iterator::hasNext).map(Iterator::next);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.uncheckedException(e, "Error finding process instance %s", id);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error finding process instance %s", id);
        }
    }

    private List<byte[]> findAllInternal() {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("SELECT payload FROM process_instances WHERE process_id = $1").execute(Tuple.of((Object)this.process.id()), this.getAsyncResultHandler(future));
            return this.getResultFromFuture(future).map(r -> StreamSupport.stream(r.spliterator(), false).map(row -> row.getBuffer(PAYLOAD)).map(Buffer::getBytes).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.uncheckedException(e, "Error finding all process instances, for processId %s", this.process.id());
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error finding all process instances, for processId %s", this.process.id());
        }
    }

    private Long countInternal() {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("SELECT COUNT(id) FROM process_instances WHERE process_id = $1").execute(Tuple.of((Object)this.process.id()), this.getAsyncResultHandler(future));
            return this.getResultFromFuture(future).map(RowSet::iterator).map(RowIterator::next).map(row -> row.getLong("count")).orElse(0L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.uncheckedException(e, "Error counting process instances, for processId %s", this.process.id());
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error counting process instances, for processId %s", this.process.id());
        }
    }

    private void init() {
        if (!this.autoDDL) {
            LOGGER.debug("Auto DDL is disabled, do not running initializer scripts");
            return;
        }
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.query(this.getQueryFromFile("exists_tables")).execute(this.getAsyncResultHandler(future));
            CompletionStage futureCompose = future.thenCompose(rows -> {
                CompletableFuture futureCreate = new CompletableFuture();
                return Optional.ofNullable(rows.iterator()).filter(Iterator::hasNext).map(Iterator::next).map(row -> row.getBoolean("exists")).filter(Boolean.FALSE::equals).map(e -> this.client.query(this.getQueryFromFile("runtime_create"))).map(q -> {
                    q.execute(this.getAsyncResultHandler(futureCreate));
                    LOGGER.info("Creating process_instances table.");
                    return futureCreate;
                }).orElseGet(() -> {
                    futureCreate.complete(null);
                    LOGGER.info("Table process_instances already exists.");
                    return futureCreate;
                });
            });
            this.getResultFromFuture((CompletableFuture<RowSet<Row>>)futureCompose).map(SqlResult::rowCount).ifPresent(count -> {
                if (count > 0) {
                    LOGGER.info("DDL successfully done for ProcessInstance");
                } else {
                    LOGGER.info("DDL executed with no changes for ProcessInstance");
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Error creating process_instances table, the database should be configured properly before starting the application", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Error creating process_instances table, the database should be configured properly before starting the application", (Throwable)e);
        }
    }

    private String getQueryFromFile(String scriptName) {
        String string;
        block8: {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format("sql/%s.sql", scriptName));
            try {
                byte[] buffer = stream.readAllBytes();
                string = new String(buffer);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.uncheckedException(e, "Error reading query script file %s", scriptName);
                }
            }
            stream.close();
        }
        return string;
    }

    private boolean updateWithLock(UUID id, byte[] payload, long version) {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("UPDATE process_instances SET payload = $1, version = $2 WHERE id = $3 and version = $4").execute(Tuple.of((Object)Buffer.buffer((byte[])payload), (Object)(version + 1L), (Object)id, (Object)version), this.getAsyncResultHandler(future));
            boolean result = this.getExecutedResult(future);
            if (!result) {
                throw this.uncheckedException(null, "The document with ID: %s was updated or deleted by other request.", id);
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error updating process instance %s", id);
        }
        return false;
    }
}

