/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.postgresql;

import io.vertx.pgclient.PgPool;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.util.io.ClassPathResource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.persistence.postgresql.AbstractProcessInstancesFactory;
import org.kie.kogito.persistence.postgresql.PostgresqlProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
class PostgresqlProcessInstancesIT {
    @Container
    static final KogitoPostgreSqlContainer container = new KogitoPostgreSqlContainer();
    private static PgPool client;
    private SecurityPolicy securityPolicy = SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)"john"));

    PostgresqlProcessInstancesIT() {
    }

    @BeforeAll
    public static void startContainerAndPublicPortIsAvailable() {
        container.start();
        client = PostgresqlProcessInstancesIT.client();
    }

    @AfterAll
    public static void close() {
        container.stop();
    }

    private BpmnProcess createProcess(String fileName) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource(fileName)}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new PostgreProcessInstancesFactory(client));
        process.configure();
        process.instances().values(ProcessInstanceReadMode.MUTABLE).forEach(p -> p.abort());
        return process;
    }

    private static PgPool client() {
        return PgPool.pool((String)container.getReactiveUrl());
    }

    @Test
    void testBasicFlow() {
        BpmnProcess process = this.createProcess("BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        PostgresqlProcessInstances processInstances = (PostgresqlProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Assertions.assertThat((boolean)processInstances.exists(processInstance.id())).isTrue();
        ProcessInstance readOnlyPI = (ProcessInstance)process.instances().findById(processInstance.id(), ProcessInstanceReadMode.READ_ONLY).get();
        Assertions.assertThat((int)readOnlyPI.status()).isEqualTo(1);
        Assertions.assertThat((int)process.instances().values(ProcessInstanceReadMode.READ_ONLY).size()).isOne();
        ((PostgresqlProcessInstances)Mockito.verify((Object)processInstances)).create((String)ArgumentMatchers.any(), (ProcessInstance)ArgumentMatchers.any());
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        Assertions.assertThat((List)((ProcessInstance)process.instances().values().iterator().next()).workItems(new Policy[]{this.securityPolicy})).hasSize(1);
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{this.securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Map)workItem.getParameters()).containsEntry((Object)"ActorId", (Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        processInstances = (PostgresqlProcessInstances)process.instances();
        ((PostgresqlProcessInstances)Mockito.verify((Object)processInstances, (VerificationMode)Mockito.times((int)2))).remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Collection)process.instances().values()).isEmpty();
    }

    @Test
    void testMultipleProcesses() {
        BpmnProcess utProcess = this.createProcess("BPMN2-UserTask.bpmn2");
        ProcessInstance utProcessInstance = utProcess.createInstance(BpmnVariables.create());
        utProcessInstance.start();
        BpmnProcess scriptProcess = this.createProcess("BPMN2-UserTask-Script.bpmn2");
        ProcessInstance scriptProcessInstance = scriptProcess.createInstance(BpmnVariables.create());
        scriptProcessInstance.start();
        ((PostgresqlProcessInstances)utProcess.instances()).remove(scriptProcessInstance.id());
        ((PostgresqlProcessInstances)scriptProcess.instances()).remove(utProcessInstance.id());
        Assertions.assertThat((Integer)utProcess.instances().size()).isOne();
        Assertions.assertThat((Collection)utProcess.instances().values()).hasSize(1);
        Assertions.assertThat((Optional)utProcess.instances().findById(utProcessInstance.id())).isPresent();
        Assertions.assertThat((Optional)utProcess.instances().findById(scriptProcessInstance.id())).isEmpty();
        Assertions.assertThat((Integer)scriptProcess.instances().size()).isOne();
        Assertions.assertThat((Collection)scriptProcess.instances().values()).hasSize(1);
        Assertions.assertThat((Optional)scriptProcess.instances().findById(scriptProcessInstance.id())).isPresent();
        Assertions.assertThat((Optional)scriptProcess.instances().findById(utProcessInstance.id())).isEmpty();
        ((PostgresqlProcessInstances)utProcess.instances()).remove(utProcessInstance.id());
        Assertions.assertThat((Integer)utProcess.instances().size()).isZero();
        Assertions.assertThat((Collection)utProcess.instances().values()).isEmpty();
        Assertions.assertThat((Optional)utProcess.instances().findById(utProcessInstance.id())).isEmpty();
        Assertions.assertThat((Optional)utProcess.instances().findById(scriptProcessInstance.id())).isEmpty();
        ((PostgresqlProcessInstances)scriptProcess.instances()).remove(scriptProcessInstance.id());
        Assertions.assertThat((Integer)scriptProcess.instances().size()).isZero();
        Assertions.assertThat((Collection)scriptProcess.instances().values()).isEmpty();
        Assertions.assertThat((Optional)scriptProcess.instances().findById(scriptProcessInstance.id())).isEmpty();
        Assertions.assertThat((Optional)scriptProcess.instances().findById(utProcessInstance.id())).isEmpty();
    }

    private class PostgreProcessInstancesFactory
    extends AbstractProcessInstancesFactory {
        public PostgreProcessInstancesFactory(PgPool client) {
            super(client, Boolean.valueOf(true), Long.valueOf(10000L), Boolean.valueOf(false));
        }

        public PostgresqlProcessInstances createProcessInstances(Process<?> process) {
            PostgresqlProcessInstances instances = (PostgresqlProcessInstances)Mockito.spy((Object)super.createProcessInstances(process));
            return instances;
        }
    }
}

