/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.postgresql;

import io.vertx.pgclient.PgPool;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.util.io.ClassPathResource;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.Model;
import org.kie.kogito.persistence.postgresql.AbstractProcessInstancesFactory;
import org.kie.kogito.persistence.postgresql.PostgresqlProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.mockito.Mockito;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
class PostgresqlProcessInstancesWithLockIT {
    @Container
    static final KogitoPostgreSqlContainer container = new KogitoPostgreSqlContainer();
    private static PgPool client;
    private static final String TEST_ID = "02ac3854-46ee-42b7-8b63-5186c9889d96";

    PostgresqlProcessInstancesWithLockIT() {
    }

    @BeforeAll
    public static void startContainerAndPublicPortIsAvailable() {
        container.start();
        client = PostgresqlProcessInstancesWithLockIT.client();
    }

    @AfterAll
    public static void close() {
        container.stop();
    }

    private BpmnProcess createProcess(String fileName) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource(fileName)}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new PostgreProcessInstancesFactory(client));
        process.configure();
        return process;
    }

    private static PgPool client() {
        return PgPool.pool((String)container.getReactiveUrl());
    }

    @Test
    public void testBasic() {
        BpmnProcess process = this.createProcess("BPMN2-UserTask.bpmn2");
        PostgresqlProcessInstances pi = new PostgresqlProcessInstances((Process)process, client, true, Long.valueOf(1000L), false);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)pi);
        WorkflowProcessInstance createPi = ((AbstractProcessInstance)process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")))).internalGetProcessInstance();
        createPi.setId(TEST_ID);
        createPi.setStartDate(new Date());
        AbstractProcessInstance mockCreatePi = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        mockCreatePi.setVersion(1L);
        Mockito.when((Object)mockCreatePi.status()).thenReturn((Object)1);
        Mockito.when((Object)mockCreatePi.internalGetProcessInstance()).thenReturn((Object)createPi);
        Mockito.when((Object)mockCreatePi.id()).thenReturn((Object)TEST_ID);
        pi.create(TEST_ID, (ProcessInstance)mockCreatePi);
        Assertions.assertThat((Integer)pi.size()).isOne();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pi.exists(TEST_ID));
        WorkflowProcessInstance updatePi = ((AbstractProcessInstance)process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")))).internalGetProcessInstance();
        updatePi.setId(TEST_ID);
        updatePi.setStartDate(new Date());
        AbstractProcessInstance mockUpdatePi = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        Mockito.when((Object)mockUpdatePi.status()).thenReturn((Object)1);
        Mockito.when((Object)mockUpdatePi.internalGetProcessInstance()).thenReturn((Object)updatePi);
        Mockito.when((Object)mockUpdatePi.id()).thenReturn((Object)TEST_ID);
        pi.update(TEST_ID, (ProcessInstance)mockUpdatePi);
        pi.remove(TEST_ID);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pi.exists(TEST_ID));
    }

    @Test
    public void testUpdate() {
        BpmnProcess process = this.createProcess("BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        PostgresqlProcessInstances processInstances = (PostgresqlProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)instanceOne.version());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)instanceTwo.version());
        instanceOne.updateVariables((Model)BpmnVariables.create(Collections.singletonMap("s", "test")));
        try {
            BpmnVariables testvar = BpmnVariables.create(Collections.singletonMap("ss", "test"));
            instanceTwo.updateVariables((Model)testvar);
            org.junit.jupiter.api.Assertions.fail((String)"Updating process should have failed");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("Process instance with id '" + instanceOne.id() + "' updated or deleted by other request");
        }
        foundOne = processInstances.findById(processInstance.id());
        instanceOne = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)instanceOne.version());
        processInstances.remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Collection)process.instances().values()).isEmpty();
    }

    @Test
    public void testRemove() {
        BpmnProcess process = this.createProcess("BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        PostgresqlProcessInstances processInstances = (PostgresqlProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)instanceOne.version());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)instanceTwo.version());
        processInstances.remove(instanceOne.id());
        processInstances.remove(instanceTwo.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
    }

    private class PostgreProcessInstancesFactory
    extends AbstractProcessInstancesFactory {
        public PostgreProcessInstancesFactory(PgPool client) {
            super(client, Boolean.valueOf(true), Long.valueOf(10000L), Boolean.valueOf(true));
        }
    }
}

