/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.postgresql;

import io.vertx.pgclient.PgPool;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.io.ClassPathResource;
import org.flywaydb.core.Flyway;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.persistence.postgresql.AbstractProcessInstancesFactory;
import org.kie.kogito.persistence.postgresql.PostgresqlProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
class PostgresqlProcessInstancesIT {
    @Container
    static final KogitoPostgreSqlContainer container = new KogitoPostgreSqlContainer();
    private static PgPool client;
    private SecurityPolicy securityPolicy = SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)"john"));

    PostgresqlProcessInstancesIT() {
    }

    @BeforeAll
    public static void startContainerAndPublicPortIsAvailable() {
        container.start();
        Flyway flyway = Flyway.configure().dataSource(container.getJdbcUrl(), container.getUsername(), container.getPassword()).load();
        flyway.migrate();
        client = PostgresqlProcessInstancesIT.client();
    }

    @AfterAll
    public static void close() {
        container.stop();
    }

    boolean lock() {
        return false;
    }

    private BpmnProcess createProcess(String fileName) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource(fileName)}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new PostgreProcessInstancesFactory(client, this.lock()));
        process.configure();
        process.instances().values(ProcessInstanceReadMode.MUTABLE).forEach(p -> p.abort());
        return process;
    }

    private static PgPool client() {
        return PgPool.pool((String)container.getReactiveUrl());
    }

    @Test
    void testBasicFlow() {
        BpmnProcess process = this.createProcess("BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("BPMN2-UserTask");
        PostgresqlProcessInstances processInstances = (PostgresqlProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Assertions.assertThat((boolean)processInstances.exists(processInstance.id())).isTrue();
        ProcessInstance readOnlyPI = (ProcessInstance)process.instances().findById(processInstance.id(), ProcessInstanceReadMode.READ_ONLY).get();
        Assertions.assertThat((int)readOnlyPI.status()).isEqualTo(1);
        Assertions.assertThat((int)process.instances().values(ProcessInstanceReadMode.READ_ONLY).size()).isOne();
        ((PostgresqlProcessInstances)Mockito.verify((Object)processInstances)).create((String)ArgumentMatchers.any(), (ProcessInstance)ArgumentMatchers.any());
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("BPMN2-UserTask");
        Assertions.assertThat((List)((ProcessInstance)process.instances().values().iterator().next()).workItems(new Policy[]{this.securityPolicy})).hasSize(1);
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{this.securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Map)workItem.getParameters()).containsEntry((Object)"ActorId", (Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        processInstances = (PostgresqlProcessInstances)process.instances();
        ((PostgresqlProcessInstances)Mockito.verify((Object)processInstances, (VerificationMode)Mockito.times((int)1))).remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Collection)process.instances().values()).isEmpty();
    }

    @Test
    void testMultipleProcesses() {
        BpmnProcess utProcess = this.createProcess("BPMN2-UserTask.bpmn2");
        ProcessInstance utProcessInstance = utProcess.createInstance(BpmnVariables.create());
        utProcessInstance.start();
        BpmnProcess scriptProcess = this.createProcess("BPMN2-UserTask-Script.bpmn2");
        ProcessInstance scriptProcessInstance = scriptProcess.createInstance(BpmnVariables.create());
        scriptProcessInstance.start();
        ((PostgresqlProcessInstances)utProcess.instances()).remove(scriptProcessInstance.id());
        ((PostgresqlProcessInstances)scriptProcess.instances()).remove(utProcessInstance.id());
        Assertions.assertThat((Integer)utProcess.instances().size()).isOne();
        Assertions.assertThat((Collection)utProcess.instances().values()).hasSize(1);
        Assertions.assertThat((Optional)utProcess.instances().findById(utProcessInstance.id())).isPresent();
        Assertions.assertThat((Optional)utProcess.instances().findById(scriptProcessInstance.id())).isEmpty();
        Assertions.assertThat((Integer)scriptProcess.instances().size()).isOne();
        Assertions.assertThat((Collection)scriptProcess.instances().values()).hasSize(1);
        Assertions.assertThat((Optional)scriptProcess.instances().findById(scriptProcessInstance.id())).isPresent();
        Assertions.assertThat((Optional)scriptProcess.instances().findById(utProcessInstance.id())).isEmpty();
        ((PostgresqlProcessInstances)utProcess.instances()).remove(utProcessInstance.id());
        Assertions.assertThat((Integer)utProcess.instances().size()).isZero();
        Assertions.assertThat((Collection)utProcess.instances().values()).isEmpty();
        Assertions.assertThat((Optional)utProcess.instances().findById(utProcessInstance.id())).isEmpty();
        Assertions.assertThat((Optional)utProcess.instances().findById(scriptProcessInstance.id())).isEmpty();
        ((PostgresqlProcessInstances)scriptProcess.instances()).remove(scriptProcessInstance.id());
        Assertions.assertThat((Integer)scriptProcess.instances().size()).isZero();
        Assertions.assertThat((Collection)scriptProcess.instances().values()).isEmpty();
        Assertions.assertThat((Optional)scriptProcess.instances().findById(scriptProcessInstance.id())).isEmpty();
        Assertions.assertThat((Optional)scriptProcess.instances().findById(utProcessInstance.id())).isEmpty();
    }

    @Test
    public void testUpdate() {
        BpmnProcess process = this.createProcess("BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        PostgresqlProcessInstances processInstances = (PostgresqlProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        Assertions.assertThat((long)instanceOne.version()).isEqualTo(this.lock() ? 1L : 0L);
        Assertions.assertThat((long)instanceTwo.version()).isEqualTo(this.lock() ? 1L : 0L);
        instanceOne.updateVariables((Model)BpmnVariables.create(Collections.singletonMap("s", "test")));
        try {
            BpmnVariables testvar = BpmnVariables.create(Collections.singletonMap("ss", "test"));
            instanceTwo.updateVariables((Model)testvar);
            if (this.lock()) {
                Assertions.fail((String)"Updating process should have failed");
            }
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("Process instance with id '" + instanceOne.id() + "' updated or deleted by other request");
        }
        foundOne = processInstances.findById(processInstance.id());
        instanceOne = (BpmnProcessInstance)foundOne.get();
        Assertions.assertThat((long)instanceOne.version()).isEqualTo(this.lock() ? 2L : 0L);
        processInstances.remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Collection)process.instances().values()).isEmpty();
    }

    @Test
    public void testRemove() {
        BpmnProcess process = this.createProcess("BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        PostgresqlProcessInstances processInstances = (PostgresqlProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        Assertions.assertThat((long)instanceOne.version()).isEqualTo(this.lock() ? 1L : 0L);
        Assertions.assertThat((long)instanceTwo.version()).isEqualTo(this.lock() ? 1L : 0L);
        processInstances.remove(instanceOne.id());
        processInstances.remove(instanceTwo.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
    }

    @Test
    void testProcessWithDifferentVersion() {
        BpmnProcess processV1 = this.createProcess("BPMN2-UserTask.bpmn2");
        BpmnProcess processV2 = this.createProcess("BPMN2-UserTask-v2.bpmn2");
        Assertions.assertThat((String)processV1.process().getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)processV2.process().getVersion()).isEqualTo("2.0");
        ProcessInstance processInstanceV1 = processV1.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstanceV1.start();
        PostgresqlProcessInstances processInstancesV1 = (PostgresqlProcessInstances)processV1.instances();
        PostgresqlProcessInstances processInstancesV2 = (PostgresqlProcessInstances)processV2.instances();
        Assertions.assertThat((Integer)processInstancesV1.size()).isOne();
        Assertions.assertThat((Optional)processInstancesV1.findById(processInstanceV1.id())).isPresent();
        Assertions.assertThat((Integer)processInstancesV2.size()).isZero();
        ProcessInstance processInstanceV2 = processV2.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstanceV2.start();
        Assertions.assertThat((Integer)processInstancesV2.size()).isOne();
        Assertions.assertThat((Optional)processInstancesV2.findById(processInstanceV2.id())).isPresent();
        processInstancesV1.remove(processInstanceV1.id());
        Assertions.assertThat((Integer)processInstancesV1.size()).isZero();
        Assertions.assertThat((Collection)processV1.instances().values()).isEmpty();
        Assertions.assertThat((Integer)processInstancesV2.size()).isOne();
        processInstancesV2.remove(processInstanceV2.id());
        Assertions.assertThat((Integer)processInstancesV2.size()).isZero();
    }

    private class PostgreProcessInstancesFactory
    extends AbstractProcessInstancesFactory {
        public PostgreProcessInstancesFactory(PgPool client, boolean lock) {
            super(client, Long.valueOf(10000L), Boolean.valueOf(lock));
        }

        public PostgresqlProcessInstances createProcessInstances(Process<?> process) {
            return (PostgresqlProcessInstances)Mockito.spy((Object)super.createProcessInstances(process));
        }
    }
}

