/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceOptimisticLockingException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlProcessInstances
implements MutableProcessInstances {
    private static final String VERSION = "version";
    private static final String PAYLOAD = "payload";
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresqlProcessInstances.class);
    private static final String IS_NULL = "is null";
    private static final String INSERT = "INSERT INTO process_instances (id, payload, process_id, process_version, version) VALUES ($1, $2, $3, $4, $5)";
    private static final String UPDATE = "UPDATE process_instances SET payload = $1 WHERE process_id = $2 and id = $3 and process_version ";
    private static final String DELETE = "DELETE FROM process_instances WHERE process_id = $1 and id = $2 and process_version ";
    private static final String FIND_BY_ID = "SELECT payload, version FROM process_instances WHERE process_id = $1 and id = $2 and process_version ";
    private static final String FIND_ALL = "SELECT payload FROM process_instances WHERE process_id = $1 and process_version ";
    private static final String COUNT = "SELECT COUNT(id) FROM process_instances WHERE process_id = $1 and process_version ";
    private static final String UPDATE_WITH_LOCK = "UPDATE process_instances SET payload = $1, version = $2 WHERE process_id = $3 and id = $4 and version = $5 and process_version ";
    private final Process<?> process;
    private final PgPool client;
    private final ProcessInstanceMarshallerService marshaller;
    private final Long queryTimeoutMillis;
    private final boolean lock;

    public PostgresqlProcessInstances(Process<?> process, PgPool client, Long queryTimeoutMillis, boolean lock) {
        this.process = process;
        this.client = client;
        this.queryTimeoutMillis = queryTimeoutMillis;
        this.marshaller = ProcessInstanceMarshallerService.newBuilder().withDefaultObjectMarshallerStrategies().build();
        this.lock = lock;
    }

    public boolean exists(String id) {
        return this.findById(id).isPresent();
    }

    public void create(String id, ProcessInstance instance) {
        if (!this.isActive(instance)) {
            this.disconnect(instance);
            return;
        }
        this.insertInternal(UUID.fromString(id), this.marshaller.marshallProcessInstance(instance));
    }

    public void update(String id, ProcessInstance instance) {
        if (!this.isActive(instance)) {
            this.disconnect(instance);
            return;
        }
        try {
            if (this.lock) {
                this.updateWithLock(UUID.fromString(id), this.marshaller.marshallProcessInstance(instance), instance.version());
            } else {
                this.updateInternal(UUID.fromString(id), this.marshaller.marshallProcessInstance(instance));
            }
        }
        finally {
            this.disconnect(instance);
        }
    }

    public void remove(String id) {
        this.deleteInternal(UUID.fromString(id));
    }

    public Optional<ProcessInstance> findById(String id, ProcessInstanceReadMode mode) {
        Optional<byte[]> payload;
        Optional<Row> row = this.findByIdInternal(UUID.fromString(id));
        if (row.isPresent() && (payload = row.map(r -> r.getBuffer(PAYLOAD)).map(Buffer::getBytes)).isPresent()) {
            ProcessInstance instance = mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(payload.get(), this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(payload.get(), this.process);
            ((AbstractProcessInstance)instance).setVersion(row.get().getLong(VERSION).longValue());
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public Collection<ProcessInstance> values(ProcessInstanceReadMode mode) {
        return this.findAllInternal().stream().map(b -> mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(b, this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(b, this.process)).collect(Collectors.toList());
    }

    public Integer size() {
        return this.countInternal().intValue();
    }

    public boolean lock() {
        return this.lock;
    }

    private void disconnect(ProcessInstance instance) {
        Supplier<byte[]> supplier = () -> {
            Optional<Row> row = this.findByIdInternal(UUID.fromString(instance.id()));
            ((AbstractProcessInstance)instance).setVersion(row.get().getLong(VERSION).longValue());
            return row.map(r -> r.getBuffer(PAYLOAD)).map(Buffer::getBytes).get();
        };
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(this.marshaller.createdReloadFunction(supplier));
    }

    private boolean insertInternal(UUID id, byte[] payload) {
        try {
            Future future = this.client.preparedQuery(INSERT).execute(Tuple.of((Object)id, (Object)Buffer.buffer((byte[])payload), (Object)this.process.id(), (Object)this.process.version(), (Object)0L));
            return this.getExecutedResult((Future<RowSet<Row>>)future);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.uncheckedException(e, "Error inserting process instance %s", id);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error inserting process instance %s", id);
        }
    }

    private RuntimeException uncheckedException(Exception ex, String message, Object ... param) {
        return new RuntimeException(String.format(message, param), ex);
    }

    private boolean updateInternal(UUID id, byte[] payload) {
        try {
            Future future = this.client.preparedQuery(UPDATE + (this.process.version() == null ? IS_NULL : "= $4")).execute(this.tuple(Buffer.buffer((byte[])payload), this.process.id(), id));
            return this.getExecutedResult((Future<RowSet<Row>>)future);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.uncheckedException(e, "Error updating process instance %s", id);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error updating process instance %s", id);
        }
    }

    private boolean deleteInternal(UUID id) {
        try {
            Future future = this.client.preparedQuery(DELETE + (this.process.version() == null ? IS_NULL : "= $3")).execute(this.tuple(this.process.id(), id));
            return this.getExecutedResult((Future<RowSet<Row>>)future);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.uncheckedException(e, "Error deleting process instance %s", id);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error deleting process instance %s", id);
        }
    }

    private Boolean getExecutedResult(Future<RowSet<Row>> future) throws ExecutionException, TimeoutException, InterruptedException {
        try {
            return this.getResultFromFuture(future).map(SqlResult::rowCount).map(count -> count == 1).orElse(false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    private Optional<RowSet<Row>> getResultFromFuture(Future<RowSet<Row>> future) throws ExecutionException, TimeoutException, InterruptedException {
        try {
            return Optional.ofNullable((RowSet)future.toCompletionStage().toCompletableFuture().get(this.queryTimeoutMillis, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    private Optional<Row> findByIdInternal(UUID id) {
        try {
            Future future = this.client.preparedQuery(FIND_BY_ID + (this.process.version() == null ? IS_NULL : "= $3")).execute(this.tuple(this.process.id(), id));
            return this.getResultFromFuture((Future<RowSet<Row>>)future).map(RowSet::iterator).filter(Iterator::hasNext).map(Iterator::next);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.uncheckedException(e, "Error finding process instance %s", id);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error finding process instance %s", id);
        }
    }

    private List<byte[]> findAllInternal() {
        try {
            Future future = this.client.preparedQuery(FIND_ALL + (this.process.version() == null ? IS_NULL : "= $2")).execute(this.tuple(this.process.id()));
            return this.getResultFromFuture((Future<RowSet<Row>>)future).map(r -> StreamSupport.stream(r.spliterator(), false).map(row -> row.getBuffer(PAYLOAD)).map(Buffer::getBytes).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.uncheckedException(e, "Error finding all process instances, for processId %s", this.process.id());
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error finding all process instances, for processId %s", this.process.id());
        }
    }

    private Tuple tuple(Object ... parameters) {
        Tuple tuple = Tuple.from((Object[])parameters);
        if (this.process.version() != null) {
            tuple.addValue((Object)this.process.version());
        }
        return tuple;
    }

    private Long countInternal() {
        try {
            Future future = this.client.preparedQuery(COUNT + (this.process.version() == null ? IS_NULL : "= $2")).execute(this.tuple(this.process.id()));
            return this.getResultFromFuture((Future<RowSet<Row>>)future).map(RowSet::iterator).map(RowIterator::next).map(row -> row.getLong("count")).orElse(0L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.uncheckedException(e, "Error counting process instances, for processId %s", this.process.id());
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error counting process instances, for processId %s", this.process.id());
        }
    }

    private String getQueryFromFile(String scriptName) {
        String string;
        block8: {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format("sql/%s.sql", scriptName));
            try {
                byte[] buffer = stream.readAllBytes();
                string = new String(buffer);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw this.uncheckedException(e, "Error reading query script file %s", scriptName);
                }
            }
            stream.close();
        }
        return string;
    }

    private boolean updateWithLock(UUID id, byte[] payload, long version) {
        try {
            Future future = this.client.preparedQuery(UPDATE_WITH_LOCK + (this.process.version() == null ? IS_NULL : "= $6")).execute(this.tuple(Buffer.buffer((byte[])payload), version + 1L, this.process.id(), id, version));
            boolean result = this.getExecutedResult((Future<RowSet<Row>>)future);
            if (!result) {
                throw new ProcessInstanceOptimisticLockingException(id.toString());
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ProcessInstanceOptimisticLockingException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error updating process instance %s", id);
        }
        return false;
    }
}

