/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.addons.common.deployment;

import io.quarkus.deployment.Capabilities;
import java.util.Collections;
import java.util.HashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.quarkus.addons.common.deployment.AnyEngineAddonProcessorImpl;
import org.kie.kogito.quarkus.addons.common.deployment.KogitoCapability;
import org.kie.kogito.quarkus.addons.common.deployment.RequireEngineAddonProcessor;

public class KogitoAddOnProcessorTest {
    @Test
    void verifyRequiredCapabilitiesWhenNotPresent() {
        RequireEngineAddonProcessor requireEngineAddonProcessor = new RequireEngineAddonProcessor();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> requireEngineAddonProcessor.verifyCapabilities(new Capabilities(Collections.emptySet())));
        Assertions.assertTrue((boolean)exception.getMessage().contains(KogitoCapability.DECISIONS.getCapability()));
        Assertions.assertTrue((boolean)exception.getMessage().contains(KogitoCapability.PREDICTIONS.getCapability()));
    }

    @Test
    void verifyAnyEngineRequiredButNotPresent() {
        AnyEngineAddonProcessorImpl anyEngineAddonProcessorImpl = new AnyEngineAddonProcessorImpl();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> anyEngineAddonProcessorImpl.verifyCapabilities(new Capabilities(Collections.emptySet())));
        Assertions.assertTrue((boolean)exception.getMessage().contains(KogitoCapability.DECISIONS.getCapability()));
        Assertions.assertTrue((boolean)exception.getMessage().contains(KogitoCapability.PREDICTIONS.getCapability()));
        Assertions.assertTrue((boolean)exception.getMessage().contains(KogitoCapability.PROCESSES.getCapability()));
        Assertions.assertTrue((boolean)exception.getMessage().contains(KogitoCapability.SERVERLESS_WORKFLOW.getCapability()));
        Assertions.assertTrue((boolean)exception.getMessage().contains(KogitoCapability.RULES.getCapability()));
    }

    @Test
    void verifyRequiredCapabilitiesWhenPresent() {
        RequireEngineAddonProcessor requireEngineAddonProcessor = new RequireEngineAddonProcessor();
        HashSet<String> capabilities = new HashSet<String>();
        capabilities.add(KogitoCapability.DECISIONS.getCapability());
        capabilities.add(KogitoCapability.PREDICTIONS.getCapability());
        Assertions.assertDoesNotThrow(() -> requireEngineAddonProcessor.verifyCapabilities(new Capabilities(capabilities)));
    }
}

