/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.task.management;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.task.management.service.TaskInfo;
import org.kie.kogito.task.management.service.TaskManagementOperations;
import org.kie.kogito.task.management.service.TaskManagementService;

@Path(value="/management/processes")
public class TaskManagementResource {
    private TaskManagementOperations taskService;
    @Inject
    private Processes processes;
    @Inject
    private ProcessConfig processConfig;

    @PostConstruct
    private void init() {
        this.taskService = new TaskManagementService(this.processes, this.processConfig);
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{processId}/instances/{processInstanceId}/tasks/{taskId}")
    public Response updateTask(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="taskId") String taskId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, TaskInfo taskInfo) {
        this.taskService.updateTask(processId, processInstanceId, taskId, taskInfo, true, Policies.of((String)user, groups));
        return Response.ok().build();
    }

    @PATCH
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{processId}/instances/{processInstanceId}/tasks/{taskId}")
    public TaskInfo partialUpdateTask(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="taskId") String taskId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, TaskInfo taskInfo) {
        return this.taskService.updateTask(processId, processInstanceId, taskId, taskInfo, false, Policies.of((String)user, groups));
    }

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{processId}/instances/{processInstanceId}/tasks/{taskId}")
    public TaskInfo getTask(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="taskId") String taskId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.taskService.getTask(processId, processInstanceId, taskId, Policies.of((String)user, groups));
    }
}

