/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.resource.exceptions;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.process.NodeInstanceNotFoundException;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.VariableViolationException;
import org.kie.kogito.process.workitem.InvalidLifeCyclePhaseException;
import org.kie.kogito.process.workitem.InvalidTransitionException;
import org.kie.kogito.process.workitem.NotAuthorizedException;
import org.kie.kogito.resource.exceptions.BaseExceptionsHandler;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class BaseExceptionHandlerTest {
    private BaseExceptionsHandler tested;
    @Mock
    private Object badRequestResponse;
    @Mock
    private Object conflictResponse;
    @Mock
    private Object internalErrorResponse;
    @Mock
    private Object notFoundResponse;
    @Mock
    private Object forbiddenResponse;

    BaseExceptionHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        this.tested = (BaseExceptionsHandler)Mockito.spy((Object)new BaseExceptionsHandler(){

            protected Object badRequest(Object body) {
                return BaseExceptionHandlerTest.this.badRequestResponse;
            }

            protected Object conflict(Object body) {
                return BaseExceptionHandlerTest.this.conflictResponse;
            }

            protected Object internalError(Object body) {
                return BaseExceptionHandlerTest.this.internalErrorResponse;
            }

            protected Object notFound(Object body) {
                return BaseExceptionHandlerTest.this.notFoundResponse;
            }

            protected Object forbidden(Object body) {
                return BaseExceptionHandlerTest.this.forbiddenResponse;
            }
        });
    }

    @Test
    void testMapInvalidLifeCyclePhaseException() {
        Object response = this.tested.mapException((Exception)new InvalidLifeCyclePhaseException("message"));
        Assertions.assertThat((Object)response).isEqualTo(this.badRequestResponse);
    }

    @Test
    void testMapInvalidTransitionException() {
        Object response = this.tested.mapException((Exception)new InvalidTransitionException("message"));
        Assertions.assertThat((Object)response).isEqualTo(this.badRequestResponse);
    }

    @Test
    void testMapNodeInstanceNotFoundException() {
        Object response = this.tested.mapException((Exception)new NodeInstanceNotFoundException("processInstanceId", "nodeInstanceId"));
        Assertions.assertThat((Object)response).isEqualTo(this.notFoundResponse);
    }

    @Test
    void testMapNotAuthorizedException() {
        Object response = this.tested.mapException((Exception)new NotAuthorizedException("message"));
        Assertions.assertThat((Object)response).isEqualTo(this.forbiddenResponse);
    }

    @Test
    void testMapProcessInstanceDuplicatedException() {
        Object response = this.tested.mapException((Exception)new ProcessInstanceDuplicatedException("processInstanceId"));
        Assertions.assertThat((Object)response).isEqualTo(this.conflictResponse);
    }

    @Test
    void testMapProcessInstanceExecutionException() {
        Object response = this.tested.mapException((Exception)new ProcessInstanceExecutionException("processInstanceId", "nodeId", "message"));
        Assertions.assertThat((Object)response).isEqualTo(this.internalErrorResponse);
    }

    @Test
    void testMapProcessInstanceNotFoundException() {
        Object response = this.tested.mapException((Exception)new ProcessInstanceNotFoundException("processInstanceId"));
        Assertions.assertThat((Object)response).isEqualTo(this.notFoundResponse);
    }

    @Test
    void testMapVariableViolationException() {
        Object response = this.tested.mapException((Exception)new VariableViolationException("processInstanceId", "variable", "message"));
        Assertions.assertThat((Object)response).isEqualTo(this.badRequestResponse);
    }
}

