/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.resource.exceptions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.kie.kogito.process.NodeInstanceNotFoundException;
import org.kie.kogito.process.NodeNotFoundException;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.VariableViolationException;
import org.kie.kogito.process.workitem.InvalidLifeCyclePhaseException;
import org.kie.kogito.process.workitem.InvalidTransitionException;
import org.kie.kogito.process.workitem.NotAuthorizedException;

public abstract class BaseExceptionsHandler<T> {
    public static final String MESSAGE = "message";
    public static final String PROCESS_INSTANCE_ID = "processInstanceId";
    public static final String VARIABLE = "variable";
    public static final String NODE_INSTANCE_ID = "nodeInstanceId";
    public static final String NODE_ID = "nodeId";
    public static final String FAILED_NODE_ID = "failedNodeId";
    public static final String ID = "id";
    private final Map<Class<? extends Exception>, Function<Exception, T>> mapper = new HashMap<Class<? extends Exception>, Function<Exception, T>>();

    protected BaseExceptionsHandler() {
        this.mapper.put(InvalidLifeCyclePhaseException.class, ex -> this.badRequest(Collections.singletonMap(MESSAGE, ex.getMessage())));
        this.mapper.put(InvalidTransitionException.class, ex -> this.badRequest(Collections.singletonMap(MESSAGE, ex.getMessage())));
        this.mapper.put(NodeInstanceNotFoundException.class, ex -> {
            NodeInstanceNotFoundException exception = (NodeInstanceNotFoundException)ex;
            HashMap<String, String> response = new HashMap<String, String>();
            response.put(MESSAGE, exception.getMessage());
            response.put(PROCESS_INSTANCE_ID, exception.getProcessInstanceId());
            response.put(NODE_INSTANCE_ID, exception.getNodeInstanceId());
            return this.notFound(response);
        });
        this.mapper.put(NodeNotFoundException.class, ex -> {
            NodeNotFoundException exception = (NodeNotFoundException)ex;
            HashMap<String, String> response = new HashMap<String, String>();
            response.put(MESSAGE, exception.getMessage());
            response.put(PROCESS_INSTANCE_ID, exception.getProcessInstanceId());
            response.put(NODE_ID, exception.getNodeId());
            return this.notFound(response);
        });
        this.mapper.put(NotAuthorizedException.class, ex -> this.forbidden(Collections.singletonMap(MESSAGE, ex.getMessage())));
        this.mapper.put(ProcessInstanceDuplicatedException.class, ex -> {
            ProcessInstanceDuplicatedException exception = (ProcessInstanceDuplicatedException)ex;
            HashMap<String, String> response = new HashMap<String, String>();
            response.put(MESSAGE, exception.getMessage());
            response.put(PROCESS_INSTANCE_ID, exception.getProcessInstanceId());
            return this.conflict(response);
        });
        this.mapper.put(ProcessInstanceExecutionException.class, ex -> {
            ProcessInstanceExecutionException exception = (ProcessInstanceExecutionException)ex;
            HashMap<String, String> response = new HashMap<String, String>();
            response.put(ID, exception.getProcessInstanceId());
            response.put(FAILED_NODE_ID, exception.getFailedNodeId());
            response.put(MESSAGE, exception.getErrorMessage());
            return this.internalError(response);
        });
        this.mapper.put(ProcessInstanceNotFoundException.class, ex -> {
            ProcessInstanceNotFoundException exception = (ProcessInstanceNotFoundException)ex;
            HashMap<String, String> response = new HashMap<String, String>();
            response.put(MESSAGE, exception.getMessage());
            response.put(PROCESS_INSTANCE_ID, exception.getProcessInstanceId());
            return this.notFound(response);
        });
        this.mapper.put(VariableViolationException.class, ex -> {
            VariableViolationException exception = (VariableViolationException)ex;
            HashMap<String, String> response = new HashMap<String, String>();
            response.put(MESSAGE, exception.getMessage() + " : " + exception.getErrorMessage());
            response.put(PROCESS_INSTANCE_ID, exception.getProcessInstanceId());
            response.put(VARIABLE, exception.getVariableName());
            return this.badRequest(response);
        });
        this.mapper.put(IllegalArgumentException.class, ex -> this.badRequest(Collections.singletonMap(MESSAGE, ex.getMessage())));
    }

    protected abstract <R> T badRequest(R var1);

    protected abstract <R> T conflict(R var1);

    protected abstract <R> T internalError(R var1);

    protected abstract <R> T notFound(R var1);

    protected abstract <R> T forbidden(R var1);

    public <R extends Exception> T mapException(R exception) {
        return (T)this.mapper.getOrDefault(exception.getClass(), this::internalError).apply(exception);
    }
}

