/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.bson.codecs.configuration.CodecRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.events.mongodb.SpringbootMongoDBEventPublisher;
import org.kie.kogito.mongodb.transaction.MongoDBTransactionManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(classes={SpringbootMongoDBEventPublisher.class, TestConfig.class}, properties={"kogito.events.processinstances.enabled=false", "kogito.events.usertasks.enabled=false", "kogito.events.variables.enabled=false", "kogito.events.processinstances.collection=testPICollection", "kogito.events.usertasks.collection=testUTCollection", "kogito.events.variables.collection=testVCollection", "kogito.events.database=testDB"})
class SpringbootMongoDBEventPublisherTest {
    @Autowired
    MongoClient mongoClient;
    @MockBean
    MongoDBTransactionManager transactionManager;
    @Autowired
    SpringbootMongoDBEventPublisher publisher;

    SpringbootMongoDBEventPublisherTest() {
    }

    @Test
    void setup() {
        this.publisher.setupSpringbootMongoDBEventPublisher();
        ((MongoClient)Mockito.verify((Object)this.mongoClient, (VerificationMode)Mockito.atLeastOnce())).getDatabase((String)Mockito.eq((Object)"testDB"));
    }

    @Test
    void mongoClient() {
        Assertions.assertEquals((Object)this.mongoClient, (Object)this.publisher.mongoClient());
    }

    @Test
    void setTransactionManager() {
        Assertions.assertEquals((Object)this.transactionManager, (Object)this.publisher.transactionManager());
    }

    @Test
    void processInstancesEvents() {
        Assertions.assertFalse((boolean)this.publisher.processInstancesEvents());
    }

    @Test
    void userTasksEvents() {
        Assertions.assertFalse((boolean)this.publisher.userTasksEvents());
    }

    @Test
    void variablesEvents() {
        Assertions.assertFalse((boolean)this.publisher.variablesEvents());
    }

    @Test
    void eventsDatabaseName() {
        Assertions.assertEquals((Object)"testDB", (Object)this.publisher.eventsDatabaseName());
    }

    @Test
    void processInstancesEventsCollection() {
        Assertions.assertEquals((Object)"testPICollection", (Object)this.publisher.processInstancesEventsCollection());
    }

    @Test
    void userTasksEventsCollection() {
        Assertions.assertEquals((Object)"testUTCollection", (Object)this.publisher.userTasksEventsCollection());
    }

    @Test
    void variablesEventsCollection() {
        Assertions.assertEquals((Object)"testVCollection", (Object)this.publisher.variablesEventsCollection());
    }

    @TestConfiguration
    public static class TestConfig {
        @Bean
        @Primary
        public MongoClient mockMongoClient() {
            MongoClient mongoClient = (MongoClient)Mockito.mock(MongoClient.class);
            MongoDatabase mongoDatabase = (MongoDatabase)Mockito.mock(MongoDatabase.class);
            MongoCollection mongoCollection = (MongoCollection)Mockito.mock(MongoCollection.class);
            Mockito.when((Object)mongoClient.getDatabase((String)ArgumentMatchers.any())).thenReturn((Object)mongoDatabase);
            Mockito.when((Object)mongoDatabase.withCodecRegistry((CodecRegistry)ArgumentMatchers.any())).thenReturn((Object)mongoDatabase);
            Mockito.when((Object)mongoDatabase.getCollection((String)ArgumentMatchers.any(), (Class)ArgumentMatchers.any())).thenReturn((Object)mongoCollection);
            Mockito.when((Object)mongoCollection.withCodecRegistry((CodecRegistry)ArgumentMatchers.any())).thenReturn((Object)mongoCollection);
            return mongoClient;
        }
    }
}

