/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management.springboot;

import java.time.ZonedDateTime;
import javax.annotation.PostConstruct;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.api.JobNotFoundException;
import org.kie.kogito.jobs.management.RestJobsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class SpringRestJobsService
extends RestJobsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringRestJobsService.class);
    private RestTemplate restTemplate;

    @Autowired
    public SpringRestJobsService(@Value(value="${kogito.jobs-service.url}") String jobServiceUrl, @Value(value="${kogito.service.url}") String callbackEndpoint, @Autowired(required=false) RestTemplate restTemplate) {
        super(jobServiceUrl, callbackEndpoint);
        this.restTemplate = restTemplate;
    }

    SpringRestJobsService() {
        this(null, null, null);
    }

    @PostConstruct
    public void initialize() {
        if (this.restTemplate == null) {
            this.restTemplate = new RestTemplate();
            LOGGER.debug("No RestTemplate found, creating a default one");
        }
    }

    public String scheduleProcessJob(ProcessJobDescription description) {
        throw new UnsupportedOperationException("Scheduling for process jobs is not yet implemented");
    }

    public String scheduleProcessInstanceJob(ProcessInstanceJobDescription description) {
        String callback = this.getCallbackEndpoint(description);
        LOGGER.debug("Job to be scheduled {} with callback URL {}", (Object)description, (Object)callback);
        Job job = this.buildJob(description, callback);
        ResponseEntity result = this.restTemplate.postForEntity(this.getJobsServiceUri(), (Object)job, String.class);
        if (result.getStatusCode().ordinal() == 200) {
            LOGGER.debug("Creating of the job {} done with status code {} ", (Object)job, (Object)result.getStatusCode());
        }
        return job.getId();
    }

    public boolean cancelJob(String id) {
        try {
            this.restTemplate.delete(this.getJobsServiceUri() + "/{id}", new Object[]{id});
            return true;
        }
        catch (RestClientException e) {
            LOGGER.debug("Exception thrown during canceling of job {}", (Object)id, (Object)e);
            return false;
        }
    }

    public ZonedDateTime getScheduledTime(String id) {
        try {
            return ((Job)this.restTemplate.getForObject(this.getJobsServiceUri() + "/{id}", Job.class, new Object[]{id})).getExpirationTime();
        }
        catch (HttpClientErrorException.NotFound e) {
            throw new JobNotFoundException(id);
        }
        catch (RestClientException e) {
            throw new RuntimeException(e);
        }
    }
}

