/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management.springboot;

import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.Processes;
import org.kie.kogito.services.jobs.impl.TriggerJobCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/management/jobs"})
public class CallbackJobsServiceResource {
    @Autowired
    Processes processes;
    @Autowired
    Application application;

    @PostMapping(value={"{processId}/instances/{processInstanceId}/timers/{timerId}"}, produces={"application/json"})
    public ResponseEntity<String> triggerTimer(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="timerId") String timerId, @RequestParam(value="limit", defaultValue="0", required=false) Integer limit) {
        if (processId == null || processInstanceId == null) {
            return ResponseEntity.badRequest().body((Object)"Process id and Process instance id must be  given");
        }
        Process process = this.processes.processById(processId);
        if (process == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("Process with id " + processId + " not found"));
        }
        return new TriggerJobCommand(processInstanceId, timerId, limit, process, this.application.unitOfWorkManager()).execute() ? ResponseEntity.ok().build() : ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("Process instance with id " + processInstanceId + " not found"));
    }
}

