/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management.springboot;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.management.RestJobsServiceTest;
import org.kie.kogito.jobs.management.springboot.SpringRestJobsService;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.serlialization.SerializationUtils;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.web.client.RestTemplate;

@ExtendWith(value={MockitoExtension.class})
class SpringRestJobsServiceTest
extends RestJobsServiceTest<SpringRestJobsService> {
    @Mock
    private RestTemplate restTemplate;
    private ObjectMapper objectMapper;

    SpringRestJobsServiceTest() {
    }

    public SpringRestJobsService createJobService(String jobServiceUrl, String callbackUrl) {
        this.objectMapper = new Jackson2ObjectMapperBuilder().build();
        SerializationUtils.registerDescriptors((ObjectMapper)this.objectMapper);
        SpringRestJobsService jobsService = new SpringRestJobsService(jobServiceUrl, callbackUrl, this.restTemplate, this.objectMapper);
        jobsService.initialize();
        return jobsService;
    }

    @Test
    void scheduleProcessInstanceJob() throws Exception {
        Mockito.when((Object)this.restTemplate.postForEntity((URI)ArgumentMatchers.any(URI.class), ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(String.class))).thenReturn((Object)ResponseEntity.ok().build());
        ProcessInstanceJobDescription processInstanceJobDescription = this.buildProcessInstanceJobDescription();
        ((SpringRestJobsService)this.tested).scheduleProcessInstanceJob(processInstanceJobDescription);
        ArgumentCaptor jobArgumentCaptor = ArgumentCaptor.forClass(HttpEntity.class);
        ((RestTemplate)Mockito.verify((Object)this.restTemplate)).postForEntity((URI)ArgumentMatchers.eq((Object)((SpringRestJobsService)this.tested).getJobsServiceUri()), jobArgumentCaptor.capture(), (Class)ArgumentMatchers.eq(String.class));
        HttpEntity request = (HttpEntity)jobArgumentCaptor.getValue();
        String json = (String)request.getBody();
        Job job = (Job)this.objectMapper.readValue(json, Job.class);
        this.assertExpectedJob(job, processInstanceJobDescription.id());
    }

    @Test
    void cancelJob() {
        ((SpringRestJobsService)this.tested).cancelJob("456");
        ((RestTemplate)Mockito.verify((Object)this.restTemplate)).delete(((SpringRestJobsService)this.tested).getJobsServiceUri() + "/{id}", new Object[]{"456"});
    }
}

