/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.aggregator;

import io.cloudevents.CloudEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.conf.StaticConfigBean;
import org.kie.kogito.dmn.DecisionTestUtils;
import org.kie.kogito.tracing.decision.DecisionTracingTestUtils;
import org.kie.kogito.tracing.decision.aggregator.DefaultAggregator;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEvent;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEventType;
import org.kie.kogito.tracing.decision.event.message.InternalMessageType;
import org.kie.kogito.tracing.decision.event.message.MessageCategory;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.kie.kogito.tracing.decision.event.trace.TraceEventType;

class DefaultAggregatorTest {
    private static DMNModel model;
    private static StaticConfigBean configBean;

    DefaultAggregatorTest() {
    }

    @BeforeAll
    static void initModel() {
        model = DecisionTestUtils.createDMNModel();
        configBean = new StaticConfigBean();
    }

    @Test
    void testAggregateWithNullListReturnsNotEnoughData() {
        DefaultAggregator aggregator = new DefaultAggregator();
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(model, "4ac4c69f-4925-4221-b67e-4b14ce47bef8", null, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "4ac4c69f-4925-4221-b67e-4b14ce47bef8");
        DefaultAggregatorTest.assertTraceEventWithNotEnoughData(traceEvent);
    }

    @Test
    void testAggregateWithEmptyListReturnsNotEnoughData() {
        DefaultAggregator aggregator = new DefaultAggregator();
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(model, "4ac4c69f-4925-4221-b67e-4b14ce47bef8", Collections.emptyList(), (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "4ac4c69f-4925-4221-b67e-4b14ce47bef8");
        DefaultAggregatorTest.assertTraceEventWithNotEnoughData(traceEvent);
    }

    @Test
    void testAggregateOnEvaluateAllWithValidListIsWorking() throws IOException {
        DefaultAggregator aggregator = new DefaultAggregator();
        List<EvaluateEvent> events = DecisionTracingTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateAll.json");
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(model, "4ac4c69f-4925-4221-b67e-4b14ce47bef8", events, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "4ac4c69f-4925-4221-b67e-4b14ce47bef8");
        DefaultAggregatorTest.assertTraceEvent(traceEvent, 2, 2, 2);
    }

    @Test
    void testAggregateOnEvaluateAllWithNullModelReturnsDmnModelNotFound() throws IOException {
        DefaultAggregator aggregator = new DefaultAggregator();
        List<EvaluateEvent> events = DecisionTracingTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateAll.json");
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(null, "4ac4c69f-4925-4221-b67e-4b14ce47bef8", events, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "4ac4c69f-4925-4221-b67e-4b14ce47bef8");
        DefaultAggregatorTest.assertTraceEvent(traceEvent, 2, 2, 2);
        DefaultAggregatorTest.assertTraceEventInternalMessage(traceEvent, InternalMessageType.DMN_MODEL_NOT_FOUND);
    }

    @Test
    void testAggregateOnEvaluateAllWithListWithOnlyFirstEventReturnsNoExecutionSteps() throws IOException {
        DefaultAggregator aggregator = new DefaultAggregator();
        List events = DecisionTracingTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateAll.json").stream().limit(1L).collect(Collectors.toList());
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(model, "4ac4c69f-4925-4221-b67e-4b14ce47bef8", events, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "4ac4c69f-4925-4221-b67e-4b14ce47bef8");
        DefaultAggregatorTest.assertTraceEvent(traceEvent, 2, 2, 0);
    }

    @Test
    void testAggregateOnEvaluateAllWithListWithMissingFirstBeforeEvaluateDecisionEventReturnsNoExecutionStepHierarchy() throws IOException {
        DefaultAggregator aggregator = new DefaultAggregator();
        List events = DecisionTracingTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateAll.json").stream().filter(e -> e.getType() != EvaluateEventType.BEFORE_EVALUATE_DECISION || !"_4055D956-1C47-479C-B3F4-BAEB61F1C929".equals(e.getNodeId())).collect(Collectors.toList());
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(model, "4ac4c69f-4925-4221-b67e-4b14ce47bef8", events, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "4ac4c69f-4925-4221-b67e-4b14ce47bef8");
        DefaultAggregatorTest.assertTraceEventWithNoExecutionStepsHierarchy(traceEvent, 2, 2, 6);
    }

    @Test
    void testAggregateOnEvaluateAllWithListWithMissingFirstAfterEvaluateDecisionEventReturnsNoExecutionStepHierarchy() throws IOException {
        DefaultAggregator aggregator = new DefaultAggregator();
        List events = DecisionTracingTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateAll.json").stream().filter(e -> e.getType() != EvaluateEventType.AFTER_EVALUATE_DECISION || !"_4055D956-1C47-479C-B3F4-BAEB61F1C929".equals(e.getNodeId())).collect(Collectors.toList());
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(model, "4ac4c69f-4925-4221-b67e-4b14ce47bef8", events, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "4ac4c69f-4925-4221-b67e-4b14ce47bef8");
        DefaultAggregatorTest.assertTraceEventWithNoExecutionStepsHierarchy(traceEvent, 2, 2, 5);
    }

    @Test
    void testAggregateOnEvaluateAllWithListWithMissingLastBeforeEvaluateDecisionEventReturnsNoExecutionStepHierarchy() throws IOException {
        DefaultAggregator aggregator = new DefaultAggregator();
        List events = DecisionTracingTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateAll.json").stream().filter(e -> e.getType() != EvaluateEventType.BEFORE_EVALUATE_DECISION || !"_8A408366-D8E9-4626-ABF3-5F69AA01F880".equals(e.getNodeId())).collect(Collectors.toList());
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(model, "4ac4c69f-4925-4221-b67e-4b14ce47bef8", events, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "4ac4c69f-4925-4221-b67e-4b14ce47bef8");
        DefaultAggregatorTest.assertTraceEventWithNoExecutionStepsHierarchy(traceEvent, 2, 2, 6);
    }

    @Test
    void testAggregateOnEvaluateAllWithListWithMissingLastAfterEvaluateDecisionEventReturnsNoExecutionStepHierarchy() throws IOException {
        DefaultAggregator aggregator = new DefaultAggregator();
        List events = DecisionTracingTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateAll.json").stream().filter(e -> e.getType() != EvaluateEventType.AFTER_EVALUATE_DECISION || !"_8A408366-D8E9-4626-ABF3-5F69AA01F880".equals(e.getNodeId())).collect(Collectors.toList());
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(model, "4ac4c69f-4925-4221-b67e-4b14ce47bef8", events, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "4ac4c69f-4925-4221-b67e-4b14ce47bef8");
        DefaultAggregatorTest.assertTraceEventWithNoExecutionStepsHierarchy(traceEvent, 2, 2, 5);
    }

    @Test
    void testAggregateOnEvaluateDecisionServiceWithValidListReturnsWorking() throws IOException {
        DefaultAggregator aggregator = new DefaultAggregator();
        List<EvaluateEvent> events = DecisionTracingTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateDecisionService.json");
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(model, "77408667-f218-40b0-a355-1bab047a3e9e", events, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "77408667-f218-40b0-a355-1bab047a3e9e");
        DefaultAggregatorTest.assertTraceEvent(traceEvent, 1, 1, 1);
    }

    @Test
    void testAggregateOnEvaluateDecisionServiceWithNullModelReturnsDmnModelNotFound() throws IOException {
        DefaultAggregator aggregator = new DefaultAggregator();
        List<EvaluateEvent> events = DecisionTracingTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateDecisionService.json");
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(null, "77408667-f218-40b0-a355-1bab047a3e9e", events, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "77408667-f218-40b0-a355-1bab047a3e9e");
        DefaultAggregatorTest.assertTraceEvent(traceEvent, 1, 1, 1);
        DefaultAggregatorTest.assertTraceEventInternalMessage(traceEvent, InternalMessageType.DMN_MODEL_NOT_FOUND);
    }

    @Test
    void testAggregateOnEvaluateDecisionServiceWithListWithOnlyFirstEventReturnsNoExecutionSteps() throws IOException {
        DefaultAggregator aggregator = new DefaultAggregator();
        List events = DecisionTracingTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateDecisionService.json").stream().limit(1L).collect(Collectors.toList());
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(model, "77408667-f218-40b0-a355-1bab047a3e9e", events, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "77408667-f218-40b0-a355-1bab047a3e9e");
        DefaultAggregatorTest.assertTraceEvent(traceEvent, 1, 0, 0);
    }

    @Test
    void testAggregateOnEvaluateDecisionServiceWithListWithMissingBeforeEvaluateDecisionEventReturnsNoExecutionStepHierarchy() throws IOException {
        DefaultAggregator aggregator = new DefaultAggregator();
        List events = DecisionTracingTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateDecisionService.json").stream().filter(e -> e.getType() != EvaluateEventType.BEFORE_EVALUATE_DECISION || !"_4055D956-1C47-479C-B3F4-BAEB61F1C929".equals(e.getNodeId())).collect(Collectors.toList());
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(model, "77408667-f218-40b0-a355-1bab047a3e9e", events, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "77408667-f218-40b0-a355-1bab047a3e9e");
        DefaultAggregatorTest.assertTraceEventWithNoExecutionStepsHierarchy(traceEvent, 1, 1, 3);
    }

    @Test
    void testAggregateOnEvaluateDecisionServiceWithListWithMissingAfterEvaluateDecisionEventReturnsNoExecutionStepHierarchy() throws IOException {
        DefaultAggregator aggregator = new DefaultAggregator();
        List events = DecisionTracingTestUtils.readEvaluateEventsFromJsonResource("/Traffic Violation_EvaluateEvents_evaluateDecisionService.json").stream().filter(e -> e.getType() != EvaluateEventType.AFTER_EVALUATE_DECISION || !"_4055D956-1C47-479C-B3F4-BAEB61F1C929".equals(e.getNodeId())).collect(Collectors.toList());
        CloudEvent cloudEvent = (CloudEvent)aggregator.aggregate(model, "77408667-f218-40b0-a355-1bab047a3e9e", events, (ConfigBean)configBean).orElseThrow(IllegalStateException::new);
        TraceEvent traceEvent = DefaultAggregatorTest.assertValidCloudEventAndGetData(cloudEvent, "77408667-f218-40b0-a355-1bab047a3e9e");
        DefaultAggregatorTest.assertTraceEventWithNoExecutionStepsHierarchy(traceEvent, 1, 1, 2);
    }

    private static TraceEvent assertValidCloudEventAndGetData(CloudEvent cloudEvent, String executionId) {
        Assertions.assertEquals((Object)executionId, (Object)cloudEvent.getId());
        Assertions.assertEquals((Object)TraceEvent.class.getName(), (Object)cloudEvent.getType());
        try {
            return (TraceEvent)DecisionTestUtils.MAPPER.readValue(cloudEvent.getData().toBytes(), TraceEvent.class);
        }
        catch (IOException e) {
            Assertions.fail((Throwable)e);
            return null;
        }
    }

    private static void assertTraceEventWithNoExecutionStepsHierarchy(TraceEvent traceEvent, int inputsSize, int outputsSize, int executionStepsSize) {
        DefaultAggregatorTest.assertTraceEvent(traceEvent, inputsSize, outputsSize, executionStepsSize);
        DefaultAggregatorTest.assertTraceEventInternalMessage(traceEvent, InternalMessageType.NO_EXECUTION_STEP_HIERARCHY);
    }

    private static void assertTraceEventWithNotEnoughData(TraceEvent traceEvent) {
        DefaultAggregatorTest.assertTraceEvent(traceEvent, 0, 0, 0);
        DefaultAggregatorTest.assertTraceEventInternalMessage(traceEvent, InternalMessageType.NOT_ENOUGH_DATA);
        Assertions.assertNull((Object)traceEvent.getHeader().getStartTimestamp());
        Assertions.assertNull((Object)traceEvent.getHeader().getEndTimestamp());
        Assertions.assertNull((Object)traceEvent.getHeader().getDuration());
    }

    private static void assertTraceEvent(TraceEvent traceEvent, int inputsSize, int outputsSize, int executionStepsSize) {
        Assertions.assertSame((Object)TraceEventType.DMN, (Object)traceEvent.getHeader().getType());
        Assertions.assertSame((Object)inputsSize, (Object)traceEvent.getInputs().size());
        Assertions.assertSame((Object)outputsSize, (Object)traceEvent.getOutputs().size());
        Assertions.assertSame((Object)executionStepsSize, (Object)traceEvent.getExecutionSteps().size());
    }

    private static void assertTraceEventInternalMessage(TraceEvent traceEvent, InternalMessageType type) {
        Assertions.assertTrue((boolean)traceEvent.getHeader().getMessages().stream().anyMatch(m -> m.getLevel() == type.getLevel() && m.getCategory() == MessageCategory.INTERNAL && type.name().equals(m.getType())));
    }
}

