/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.event.evaluate;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.event.AfterEvaluateAllEvent;
import org.kie.dmn.api.core.event.AfterEvaluateBKMEvent;
import org.kie.dmn.api.core.event.AfterEvaluateContextEntryEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionServiceEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.AfterInvokeBKMEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateAllEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateBKMEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateContextEntryEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionServiceEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.BeforeInvokeBKMEvent;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.feel.util.Pair;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEventType;

class EvaluateEventTypeTest {
    private static final Map<EvaluateEventType, Pair<String, Class<?>>> CHECK_MAP = new HashMap<EvaluateEventType, Pair<String, Class<?>>>(){
        {
            this.put(EvaluateEventType.BEFORE_EVALUATE_ALL, new Pair((Object)"beforeEvaluateAll", BeforeEvaluateAllEvent.class));
            this.put(EvaluateEventType.AFTER_EVALUATE_ALL, new Pair((Object)"afterEvaluateAll", AfterEvaluateAllEvent.class));
            this.put(EvaluateEventType.BEFORE_EVALUATE_BKM, new Pair((Object)"beforeEvaluateBKM", BeforeEvaluateBKMEvent.class));
            this.put(EvaluateEventType.AFTER_EVALUATE_BKM, new Pair((Object)"afterEvaluateBKM", AfterEvaluateBKMEvent.class));
            this.put(EvaluateEventType.BEFORE_EVALUATE_CONTEXT_ENTRY, new Pair((Object)"beforeEvaluateContextEntry", BeforeEvaluateContextEntryEvent.class));
            this.put(EvaluateEventType.AFTER_EVALUATE_CONTEXT_ENTRY, new Pair((Object)"afterEvaluateContextEntry", AfterEvaluateContextEntryEvent.class));
            this.put(EvaluateEventType.BEFORE_EVALUATE_DECISION, new Pair((Object)"beforeEvaluateDecision", BeforeEvaluateDecisionEvent.class));
            this.put(EvaluateEventType.AFTER_EVALUATE_DECISION, new Pair((Object)"afterEvaluateDecision", AfterEvaluateDecisionEvent.class));
            this.put(EvaluateEventType.BEFORE_EVALUATE_DECISION_SERVICE, new Pair((Object)"beforeEvaluateDecisionService", BeforeEvaluateDecisionServiceEvent.class));
            this.put(EvaluateEventType.AFTER_EVALUATE_DECISION_SERVICE, new Pair((Object)"afterEvaluateDecisionService", AfterEvaluateDecisionServiceEvent.class));
            this.put(EvaluateEventType.BEFORE_EVALUATE_DECISION_TABLE, new Pair((Object)"beforeEvaluateDecisionTable", BeforeEvaluateDecisionTableEvent.class));
            this.put(EvaluateEventType.AFTER_EVALUATE_DECISION_TABLE, new Pair((Object)"afterEvaluateDecisionTable", AfterEvaluateDecisionTableEvent.class));
            this.put(EvaluateEventType.BEFORE_INVOKE_BKM, new Pair((Object)"beforeInvokeBKM", BeforeInvokeBKMEvent.class));
            this.put(EvaluateEventType.AFTER_INVOKE_BKM, new Pair((Object)"afterInvokeBKM", AfterInvokeBKMEvent.class));
        }
    };
    private static final Class<DMNRuntimeEventListener> LISTENER_CLASS = DMNRuntimeEventListener.class;

    EvaluateEventTypeTest() {
    }

    @Test
    void testExistingEvents() {
        CHECK_MAP.forEach((type, checkPair) -> Assertions.assertDoesNotThrow(() -> LISTENER_CLASS.getDeclaredMethod((String)checkPair.getLeft(), (Class)checkPair.getRight()), () -> String.format("Listener method \"%s(%s)\" not found for EvaluateEventType.%s", checkPair.getLeft(), ((Class)checkPair.getRight()).getSimpleName(), type)));
    }

    @Test
    void testNotManagedEvents() {
        for (Method listenerMethod : LISTENER_CLASS.getMethods()) {
            Optional<Map.Entry> optEntry = CHECK_MAP.entrySet().stream().filter(e -> ((String)((Pair)e.getValue()).getLeft()).equals(listenerMethod.getName())).findAny();
            Assertions.assertTrue((boolean)optEntry.isPresent(), () -> String.format("No EvaluateEventType for listener method \"%s\"", listenerMethod.getName()));
        }
    }

    @Test
    void testNotManagedTypes() {
        for (EvaluateEventType t : EvaluateEventType.values()) {
            Assertions.assertTrue((boolean)CHECK_MAP.containsKey(t), () -> String.format("No test entry for EvaluateEventType.%s", t));
        }
    }
}

