/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.kogito.tracing.decision.event.EventUtils;
import org.kie.kogito.tracing.decision.message.InternalMessageType;
import org.kie.kogito.tracing.typedvalue.BaseTypedValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.mockito.Mockito;

class EventUtilsTest {
    EventUtilsTest() {
    }

    @Test
    void testDoesNotThrowOnNullValues() {
        Assertions.assertThatNoException().isThrownBy(() -> EventUtils.map(null, null));
        Assertions.assertThatNoException().isThrownBy(() -> EventUtils.messageFrom((DMNMessage)null));
        Assertions.assertThatNoException().isThrownBy(() -> EventUtils.messageFrom((InternalMessageType)null));
        Assertions.assertThatNoException().isThrownBy(() -> EventUtils.messageFrom(null, null));
        Assertions.assertThatNoException().isThrownBy(() -> EventUtils.messageExceptionFieldFrom(null));
        Assertions.assertThatNoException().isThrownBy(() -> EventUtils.messageFEELEventFrom(null));
        Assertions.assertThatNoException().isThrownBy(() -> EventUtils.messageFEELEventSeverityFrom(null));
        Assertions.assertThatNoException().isThrownBy(() -> EventUtils.messageLevelFrom(null));
        Assertions.assertThatNoException().isThrownBy(() -> EventUtils.traceResourceIdFrom(null, null));
        Assertions.assertThatNoException().isThrownBy(() -> EventUtils.typedValueFrom(null));
        Assertions.assertThatNoException().isThrownBy(() -> EventUtils.typedValueFrom(null, null));
    }

    @Test
    void testTypedVariableFromJsonNode() throws JsonProcessingException {
        ObjectReader reader = new ObjectMapper().reader();
        TypedValue value = EventUtils.typedValueFromJsonNode(null, null);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Comparable)value.getKind()).isSameAs((Object)BaseTypedValue.Kind.UNIT);
        Assertions.assertThat((String)value.getType()).isEqualTo(BuiltInType.UNKNOWN.getName());
        value = EventUtils.typedValueFromJsonNode((JsonNode)reader.readTree("true"), null);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Comparable)value.getKind()).isSameAs((Object)BaseTypedValue.Kind.UNIT);
        Assertions.assertThat((String)value.getType()).isEqualTo(BuiltInType.BOOLEAN.getName());
        value = EventUtils.typedValueFromJsonNode((JsonNode)reader.readTree("12"), null);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Comparable)value.getKind()).isSameAs((Object)BaseTypedValue.Kind.UNIT);
        Assertions.assertThat((String)value.getType()).isEqualTo(BuiltInType.NUMBER.getName());
        value = EventUtils.typedValueFromJsonNode((JsonNode)reader.readTree("\"test\""), null);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Comparable)value.getKind()).isSameAs((Object)BaseTypedValue.Kind.UNIT);
        Assertions.assertThat((String)value.getType()).isEqualTo(BuiltInType.STRING.getName());
        value = EventUtils.typedValueFromJsonNode((JsonNode)reader.readTree("[1,2,3]"), null);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Comparable)value.getKind()).isSameAs((Object)BaseTypedValue.Kind.COLLECTION);
        Assertions.assertThat((String)value.getType()).isEqualTo(BuiltInType.LIST.getName());
        value = EventUtils.typedValueFromJsonNode((JsonNode)reader.readTree("{\"name\": \"John\", \"age\": 45, \"married\": true}"), null);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Comparable)value.getKind()).isSameAs((Object)BaseTypedValue.Kind.STRUCTURE);
        Assertions.assertThat((String)value.getType()).isEqualTo(BuiltInType.UNKNOWN.getName());
    }

    @Test
    void testTypedVariableFromJsonNodeWithDMNType() throws JsonProcessingException {
        ObjectReader reader = new ObjectMapper().reader();
        TypedValue value = EventUtils.typedValueFromJsonNode((DMNType)this.mockDMNType("Any"), null, null);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Comparable)value.getKind()).isSameAs((Object)BaseTypedValue.Kind.UNIT);
        Assertions.assertThat((String)value.getType()).isEqualTo(BuiltInType.UNKNOWN.getName());
        value = EventUtils.typedValueFromJsonNode((DMNType)this.mockDMNType("boolean"), (JsonNode)reader.readTree("true"), null);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Comparable)value.getKind()).isSameAs((Object)BaseTypedValue.Kind.UNIT);
        Assertions.assertThat((String)value.getType()).isEqualTo(BuiltInType.BOOLEAN.getName());
        value = EventUtils.typedValueFromJsonNode((DMNType)this.mockDMNType("number"), (JsonNode)reader.readTree("12"), null);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Comparable)value.getKind()).isSameAs((Object)BaseTypedValue.Kind.UNIT);
        Assertions.assertThat((String)value.getType()).isEqualTo(BuiltInType.NUMBER.getName());
        value = EventUtils.typedValueFromJsonNode((DMNType)this.mockDMNType("string"), (JsonNode)reader.readTree("\"test\""), null);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Comparable)value.getKind()).isSameAs((Object)BaseTypedValue.Kind.UNIT);
        Assertions.assertThat((String)value.getType()).isEqualTo(BuiltInType.STRING.getName());
        value = EventUtils.typedValueFromJsonNode((DMNType)this.mockDMNType("number"), (JsonNode)reader.readTree("[1,2,3]"), null);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Comparable)value.getKind()).isSameAs((Object)BaseTypedValue.Kind.COLLECTION);
        Assertions.assertThat((String)value.getType()).isEqualTo(BuiltInType.NUMBER.getName());
        value = EventUtils.typedValueFromJsonNode((DMNType)this.mockDMNType("Person"), (JsonNode)reader.readTree("{\"name\": \"John\", \"age\": 45, \"married\": true}"), null);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Comparable)value.getKind()).isSameAs((Object)BaseTypedValue.Kind.STRUCTURE);
        Assertions.assertThat((String)value.getType()).isEqualTo("Person");
    }

    private DMNType mockDMNType(String name) {
        DMNType mock = (DMNType)Mockito.mock(DMNType.class);
        Mockito.when((Object)mock.getName()).thenReturn((Object)name);
        return mock;
    }
}

