/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.common.Address;
import org.kie.kogito.incubation.common.EmptyMetaDataContext;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MapLikeDataContext;
import org.kie.kogito.incubation.common.MetaDataContext;
import org.kie.kogito.incubation.common.User;
import org.kie.kogito.incubation.common.objectmapper.InternalObjectMapper;

public class DataContextTest {
    @Test
    public void fromMap() {
        MapDataContext ctx = MapDataContext.create();
        ctx.set("firstName", (Object)"Paul");
        ctx.set("lastName", (Object)"McCartney");
        User u = (User)ctx.as(User.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Paul", (Object)u.firstName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"McCartney", (Object)u.lastName);
    }

    @Test
    public void toMap() {
        User u = new User();
        u.firstName = "Paul";
        u.lastName = "McCartney";
        MapLikeDataContext ctx = (MapLikeDataContext)u.as(MapLikeDataContext.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Paul", (Object)ctx.get("firstName"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"McCartney", (Object)ctx.get("lastName"));
        MapLikeDataContext ctx2 = (MapLikeDataContext)u.as(MapDataContext.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Paul", (Object)ctx2.get("firstName"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"McCartney", (Object)ctx2.get("lastName"));
    }

    @Test
    public void nestedValue() {
        User u = new User();
        u.firstName = "Paul";
        u.lastName = "McCartney";
        u.addr = new Address();
        u.addr.street = "Abbey Rd.";
        MapDataContext ctx = (MapDataContext)u.as(MapDataContext.class);
        org.junit.jupiter.api.Assertions.assertNotEquals(Address.class, ctx.get("addr").getClass());
        Address addr = (Address)InternalObjectMapper.objectMapper().convertValue(ctx.get("addr"), Address.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Abbey Rd.", (Object)addr.street);
    }

    @Test
    public void getTypedValueFromMap() {
        User u = new User();
        u.firstName = "Paul";
        u.lastName = "McCartney";
        u.addr = new Address();
        u.addr.street = "Abbey Rd.";
        MapDataContext mdc = MapDataContext.of(Map.of("Paul", u));
        User paul = (User)mdc.get("Paul");
        User user = (User)mdc.get("Paul", User.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)user);
        org.junit.jupiter.api.Assertions.assertEquals((Object)paul, (Object)user);
    }

    @Test
    public void testFastAsUsingCast() {
        MapDataContext ctx = new MapDataContext(Map.of("full name", "John Doe", "age", 47));
        MapDataContext converted = (MapDataContext)ctx.as(MapDataContext.class);
        Assertions.assertThat((Object)converted).isSameAs((Object)ctx);
    }

    @Test
    public void shouldAllowEmptyMetaDataContext() throws JsonProcessingException {
        MetaDataContext mdc = EmptyMetaDataContext.Instance;
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{}", (Object)new ObjectMapper().writeValueAsString((Object)mdc));
    }
}

