/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.common;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.common.Address;
import org.kie.kogito.incubation.common.CustomMeta;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MetaDataContext;
import org.kie.kogito.incubation.common.User;

public class ExtendedDataContextTest {
    @Test
    public void convertReturnsDataSection() {
        User data = new User();
        data.firstName = "Paul";
        data.lastName = "McCartney";
        data.addr = new Address();
        data.addr.street = "Abbey Rd.";
        MapDataContext meta = MapDataContext.create();
        meta.set("meta-value", (Object)"this is not data");
        ExtendedDataContext ctx = ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
        Assertions.assertEquals((Object)ctx.data().as(MapDataContext.class), (Object)ctx.as(MapDataContext.class), (String)"Converting an ExtendedContext should be equivalent to converting its data section");
    }

    @Test
    public void convertToExtendedIsNoOp() {
        User data = new User();
        data.firstName = "Paul";
        data.lastName = "McCartney";
        data.addr = new Address();
        data.addr.street = "Abbey Rd.";
        MapDataContext meta = MapDataContext.create();
        meta.set("meta-value", (Object)"this is not data");
        ExtendedDataContext ctx = ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
        Assertions.assertSame((Object)ctx, (Object)ctx.as(DataContext.class));
        Assertions.assertSame((Object)ctx, (Object)ctx.as(ExtendedDataContext.class));
        Assertions.assertEquals((Object)ctx.data().as(MapDataContext.class), (Object)ctx.as(MapDataContext.class), (String)"Converting an ExtendedContext should be equivalent to converting its data section");
    }

    @Test
    public void convertDataContextToExtendedWraps() {
        User data = new User();
        data.firstName = "Paul";
        data.lastName = "McCartney";
        data.addr = new Address();
        data.addr.street = "Abbey Rd.";
        ExtendedDataContext edc = (ExtendedDataContext)data.as(ExtendedDataContext.class);
        Assertions.assertEquals((Object)data, (Object)edc.data());
    }

    @Test
    public void convertMapDataContextToExtendedWraps() {
        User data = new User();
        data.firstName = "Paul";
        data.lastName = "McCartney";
        data.addr = new Address();
        data.addr.street = "Abbey Rd.";
        MapDataContext mapData = (MapDataContext)data.as(MapDataContext.class);
        ExtendedDataContext edc = (ExtendedDataContext)mapData.as(ExtendedDataContext.class);
        Assertions.assertEquals((Object)mapData, (Object)edc.data());
    }

    @Test
    public void convertMetaToMap() {
        User data = new User();
        data.firstName = "Paul";
        data.lastName = "McCartney";
        data.addr = new Address();
        data.addr.street = "Abbey Rd.";
        MapDataContext meta = MapDataContext.create();
        meta.set("meta-value", (Object)"this is not data");
        ExtendedDataContext ctx = ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
        Assertions.assertEquals((Object)meta, (Object)ctx.meta());
        MapDataContext fromMeta = MapDataContext.from((Object)ctx.meta());
        Assertions.assertEquals((Object)meta, (Object)fromMeta);
    }

    @Test
    public void convertCustomMetaToMap() {
        User data = new User();
        data.firstName = "Paul";
        data.lastName = "McCartney";
        data.addr = new Address();
        data.addr.street = "Abbey Rd.";
        CustomMeta meta = new CustomMeta();
        meta.value = "this is not data";
        ExtendedDataContext ctx = ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
        Assertions.assertEquals((Object)meta, (Object)ctx.meta());
        MapDataContext fromMeta = MapDataContext.from((Object)ctx.meta());
        Assertions.assertEquals((Object)meta.value, (Object)fromMeta.get("value"));
    }
}

