/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.common.Address;
import org.kie.kogito.incubation.common.EmptyMetaDataContext;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MapLikeDataContext;
import org.kie.kogito.incubation.common.MetaDataContext;
import org.kie.kogito.incubation.common.User;
import org.kie.kogito.incubation.common.objectmapper.InternalObjectMapper;

public class DataContextTest {
    @Test
    public void fromMap() {
        MapDataContext ctx = MapDataContext.create();
        ctx.set("firstName", (Object)"Paul");
        ctx.set("lastName", (Object)"McCartney");
        User u = (User)ctx.as(User.class);
        Assertions.assertThat((String)u.firstName).isEqualTo("Paul");
        Assertions.assertThat((String)u.lastName).isEqualTo("McCartney");
    }

    @Test
    public void toMap() {
        User u = new User();
        u.firstName = "Paul";
        u.lastName = "McCartney";
        MapLikeDataContext ctx = (MapLikeDataContext)u.as(MapLikeDataContext.class);
        Assertions.assertThat((Object)ctx.get("firstName")).isEqualTo((Object)"Paul");
        Assertions.assertThat((Object)ctx.get("lastName")).isEqualTo((Object)"McCartney");
        MapLikeDataContext ctx2 = (MapLikeDataContext)u.as(MapDataContext.class);
        Assertions.assertThat((Object)ctx2.get("firstName")).isEqualTo((Object)"Paul");
        Assertions.assertThat((Object)ctx2.get("lastName")).isEqualTo((Object)"McCartney");
    }

    @Test
    public void nestedValue() {
        User u = new User();
        u.firstName = "Paul";
        u.lastName = "McCartney";
        u.addr = new Address();
        u.addr.street = "Abbey Rd.";
        MapDataContext ctx = (MapDataContext)u.as(MapDataContext.class);
        Assertions.assertThat(ctx.get("addr").getClass()).isNotEqualTo(Address.class);
        Address addr = (Address)InternalObjectMapper.objectMapper().convertValue(ctx.get("addr"), Address.class);
        Assertions.assertThat((String)addr.street).isEqualTo("Abbey Rd.");
    }

    @Test
    public void getTypedValueFromMap() {
        User u = new User();
        u.firstName = "Paul";
        u.lastName = "McCartney";
        u.addr = new Address();
        u.addr.street = "Abbey Rd.";
        MapDataContext mdc = MapDataContext.of(Map.of("Paul", u));
        User paul = (User)mdc.get("Paul");
        User user = (User)mdc.get("Paul", User.class);
        ((ObjectAssert)Assertions.assertThat((Object)user).isNotNull()).isEqualTo((Object)paul);
    }

    @Test
    public void testFastAsUsingCast() {
        MapDataContext ctx = new MapDataContext(Map.of("full name", "John Doe", "age", 47));
        MapDataContext converted = (MapDataContext)ctx.as(MapDataContext.class);
        Assertions.assertThat((Object)converted).isSameAs((Object)ctx);
    }

    @Test
    public void shouldAllowEmptyMetaDataContext() throws JsonProcessingException {
        MetaDataContext mdc = EmptyMetaDataContext.Instance;
        Assertions.assertThat((String)new ObjectMapper().writeValueAsString((Object)mdc)).isEqualTo("{}");
    }
}

