/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.common;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.common.Address;
import org.kie.kogito.incubation.common.CustomMeta;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MetaDataContext;
import org.kie.kogito.incubation.common.User;

public class ExtendedDataContextTest {
    @Test
    public void convertReturnsDataSection() {
        User data = new User();
        data.firstName = "Paul";
        data.lastName = "McCartney";
        data.addr = new Address();
        data.addr.street = "Abbey Rd.";
        MapDataContext meta = MapDataContext.create();
        meta.set("meta-value", (Object)"this is not data");
        ExtendedDataContext ctx = ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
        ((ObjectAssert)Assertions.assertThat((Object)((MapDataContext)ctx.as(MapDataContext.class))).as("Converting an ExtendedContext should be equivalent to converting its data section", new Object[0])).isEqualTo((Object)ctx.data().as(MapDataContext.class));
    }

    @Test
    public void convertToExtendedIsNoOp() {
        User data = new User();
        data.firstName = "Paul";
        data.lastName = "McCartney";
        data.addr = new Address();
        data.addr.street = "Abbey Rd.";
        MapDataContext meta = MapDataContext.create();
        meta.set("meta-value", (Object)"this is not data");
        ExtendedDataContext ctx = ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
        Assertions.assertThat((Object)ctx.as(DataContext.class)).isSameAs((Object)ctx);
        Assertions.assertThat((Object)((ExtendedDataContext)ctx.as(ExtendedDataContext.class))).isSameAs((Object)ctx);
        ((ObjectAssert)Assertions.assertThat((Object)((MapDataContext)ctx.as(MapDataContext.class))).as("Converting an ExtendedContext should be equivalent to converting its data section", new Object[0])).isEqualTo((Object)ctx.data().as(MapDataContext.class));
    }

    @Test
    public void convertDataContextToExtendedWraps() {
        User data = new User();
        data.firstName = "Paul";
        data.lastName = "McCartney";
        data.addr = new Address();
        data.addr.street = "Abbey Rd.";
        ExtendedDataContext edc = (ExtendedDataContext)data.as(ExtendedDataContext.class);
        Assertions.assertThat((Object)edc.data()).isEqualTo((Object)data);
    }

    @Test
    public void convertMapDataContextToExtendedWraps() {
        User data = new User();
        data.firstName = "Paul";
        data.lastName = "McCartney";
        data.addr = new Address();
        data.addr.street = "Abbey Rd.";
        MapDataContext mapData = (MapDataContext)data.as(MapDataContext.class);
        ExtendedDataContext edc = (ExtendedDataContext)mapData.as(ExtendedDataContext.class);
        Assertions.assertThat((Object)edc.data()).isEqualTo((Object)mapData);
    }

    @Test
    public void convertMetaToMap() {
        User data = new User();
        data.firstName = "Paul";
        data.lastName = "McCartney";
        data.addr = new Address();
        data.addr.street = "Abbey Rd.";
        MapDataContext meta = MapDataContext.create();
        meta.set("meta-value", (Object)"this is not data");
        ExtendedDataContext ctx = ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
        Assertions.assertThat((Object)ctx.meta()).isEqualTo((Object)meta);
        MapDataContext fromMeta = MapDataContext.from((Object)ctx.meta());
        Assertions.assertThat((Object)fromMeta).isEqualTo((Object)meta);
    }

    @Test
    public void convertCustomMetaToMap() {
        User data = new User();
        data.firstName = "Paul";
        data.lastName = "McCartney";
        data.addr = new Address();
        data.addr.street = "Abbey Rd.";
        CustomMeta meta = new CustomMeta();
        meta.value = "this is not data";
        ExtendedDataContext ctx = ExtendedDataContext.of((MetaDataContext)meta, (DataContext)data);
        Assertions.assertThat((Object)ctx.meta()).isEqualTo((Object)meta);
        MapDataContext fromMeta = MapDataContext.from((Object)ctx.meta());
        Assertions.assertThat((Object)fromMeta.get("value")).isEqualTo((Object)meta.value);
    }
}

