/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.common;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.common.ComponentRoot;
import org.kie.kogito.incubation.common.LocalUri;
import org.kie.kogito.incubation.common.LocalUriId;

public class PathLocalIdTest {
    ExampleRoot exampleRoot = new ExampleRoot();

    @Test
    public void testId() {
        ExampleLocalId exampleLocalId = this.exampleRoot.get("some-id");
        Assertions.assertThat((String)exampleLocalId.asLocalUri().path()).isEqualTo("/example/some-id");
    }

    @Test
    public void testIdNested() {
        ExampleInstanceLocalId exampleLocalId = this.exampleRoot.get("some-id").instances().get("some-instance-id");
        Assertions.assertThat((String)exampleLocalId.asLocalUri().path()).isEqualTo("/example/some-id/instances/some-instance-id");
    }

    @Test
    public void testStartsWith() {
        ExampleInstanceLocalId exampleLocalId = this.exampleRoot.get("some-id").instances().get("some-instance-id");
        Assertions.assertThat((boolean)exampleLocalId.asLocalUri().startsWith("example")).isTrue();
    }

    static class ExampleRoot
    implements ComponentRoot {
        ExampleRoot() {
        }

        public ExampleLocalId get(String identifier) {
            return new ExampleLocalId(identifier);
        }
    }

    static class ExampleLocalId
    extends LocalUriId {
        private static String PREFIX = "example";

        private ExampleLocalId(String identifier) {
            super(LocalUri.Root.append(PREFIX).append(identifier));
        }

        public ExampleInstanceLocalIdFactory instances() {
            return new ExampleInstanceLocalIdFactory(this);
        }
    }

    static class ExampleInstanceLocalIdFactory {
        LocalUri parent;

        public ExampleInstanceLocalIdFactory(ExampleLocalId parent) {
            this.parent = parent.asLocalUri().append("instances");
        }

        ExampleInstanceLocalId get(String identifier) {
            return new ExampleInstanceLocalId(this.parent, identifier);
        }
    }

    static class ExampleInstanceLocalId
    extends LocalUriId {
        public ExampleInstanceLocalId(LocalUri parent, String identifier) {
            super(parent.append(identifier));
        }
    }
}

