/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.decision;

import com.github.javaparser.ast.CompilationUnit;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.ApplicationSection;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.KogitoContextTestUtils;
import org.kie.kogito.codegen.core.DashboardGeneratedFileUtils;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.grafana.JGrafana;

public class DecisionCodegenTest {
    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void isEmpty(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        DecisionCodegen emptyCodeGenerator = DecisionCodegen.ofCollectedResources((KogitoBuildContext)context, Collections.emptyList());
        Assertions.assertThat((boolean)emptyCodeGenerator.isEmpty()).isTrue();
        Assertions.assertThat((boolean)emptyCodeGenerator.isEnabled()).isFalse();
        Collection emptyGeneratedFiles = emptyCodeGenerator.generate();
        Assertions.assertThat((int)emptyGeneratedFiles.size()).isEqualTo(0);
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision/models/vacationDays", contextBuilder);
        Assertions.assertThat((boolean)codeGenerator.isEmpty()).isFalse();
        Assertions.assertThat((boolean)codeGenerator.isEnabled()).isTrue();
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(1);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateAllFiles(KogitoBuildContext.Builder contextBuilder) {
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision/models/vacationDays", contextBuilder);
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(6);
        ArrayList<String> expectedResources = new ArrayList<String>(Arrays.asList("decision/InputSet.java", "decision/OutputSet.java", "decision/TEmployee.java", "decision/TAddress.java", "decision/TPayroll.java", "org/kie/kogito/app/DecisionModelResourcesProvider.java"));
        if (contextBuilder.build().hasRESTForGenerator((Generator)codeGenerator)) {
            expectedResources.add("decision/VacationsResource.java");
        }
        Assertions.assertThat(this.fileNames(generatedFiles)).containsAll(expectedResources);
        this.assertNotEmptySectionCompilationUnit(codeGenerator);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void doNotGenerateTypesafeInfo(KogitoBuildContext.Builder contextBuilder) {
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision/alltypes/", contextBuilder);
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(3);
        ArrayList<String> expectedResources = new ArrayList<String>(Arrays.asList("http_58_47_47www_46trisotech_46com_47definitions_47__4f5608e9_454d74_454c22_45a47e_45ab657257fc9c/InputSet.java", "http_58_47_47www_46trisotech_46com_47definitions_47__4f5608e9_454d74_454c22_45a47e_45ab657257fc9c/OutputSet.java", "org/kie/kogito/app/DecisionModelResourcesProvider.java"));
        if (contextBuilder.build().hasRESTForGenerator((Generator)codeGenerator)) {
            expectedResources.add("http_58_47_47www_46trisotech_46com_47definitions_47__4f5608e9_454d74_454c22_45a47e_45ab657257fc9c/OneOfEachTypeResource.java");
        }
        Assertions.assertThat(this.fileNames(generatedFiles)).containsAll(expectedResources);
        this.assertNotEmptySectionCompilationUnit(codeGenerator);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void givenADMNModelWhenMonitoringIsActiveThenGrafanaDashboardsAreGenerated(KogitoBuildContext.Builder contextBuilder) throws Exception {
        DecisionCodegen decisionCodeGenerator = this.getDecisionCodegen("src/test/resources/decision/models/vacationDays", AddonsConfig.builder().withMonitoring(true).withPrometheusMonitoring(true).build(), contextBuilder);
        List<GeneratedFile> dashboards = this.generateTestDashboards(contextBuilder, decisionCodeGenerator);
        if (contextBuilder.build().hasRESTForGenerator((Generator)decisionCodeGenerator)) {
            JGrafana vacationOperationalDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("operational-dashboard-Vacations.json")).findFirst().get().contents()));
            org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)vacationOperationalDashboard.getDashboard().panels.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)vacationOperationalDashboard.getDashboard().links.size());
            JGrafana vacationDomainDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("domain-dashboard-Vacations.json")).findFirst().get().contents()));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)vacationDomainDashboard.getDashboard().panels.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)vacationDomainDashboard.getDashboard().links.size());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void givenADMNModelWhenMonitoringAndTracingAreActiveThenTheGrafanaDashboardsContainsTheAuditUILink(KogitoBuildContext.Builder contextBuilder) throws Exception {
        DecisionCodegen decisionCodeGenerator = this.getDecisionCodegen("src/test/resources/decision/models/vacationDays", AddonsConfig.builder().withMonitoring(true).withPrometheusMonitoring(true).withTracing(true).build(), contextBuilder);
        List<GeneratedFile> dashboards = this.generateTestDashboards(contextBuilder, decisionCodeGenerator);
        if (contextBuilder.build().hasRESTForGenerator((Generator)decisionCodeGenerator)) {
            JGrafana vacationOperationalDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("operational-dashboard-Vacations.json")).findFirst().get().contents()));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)vacationOperationalDashboard.getDashboard().links.size());
            JGrafana vacationDomainDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("domain-dashboard-Vacations.json")).findFirst().get().contents()));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)vacationDomainDashboard.getDashboard().links.size());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void resilientToDuplicateDMNIDs(KogitoBuildContext.Builder contextBuilder) {
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision-test20200507", contextBuilder);
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(3);
        this.assertNotEmptySectionCompilationUnit(codeGenerator);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void emptyName(KogitoBuildContext.Builder contextBuilder) {
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision-empty-name", contextBuilder);
        RuntimeException re = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> ((DecisionCodegen)codeGenerator).generate());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Model name should not be empty", (Object)re.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void testNSEW_positive(KogitoBuildContext.Builder contextBuilder) {
        contextBuilder.withClassAvailabilityResolver(KogitoContextTestUtils.mockClassAvailabilityResolver(Collections.singleton("org.eclipse.microprofile.openapi.models.OpenAPI"), Collections.emptyList()));
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision-NSEW", contextBuilder);
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((Iterable)generatedFiles).anyMatch(x -> x.relativePath().endsWith("InputSet.java"));
        GeneratedFile inputSetFile = generatedFiles.stream().filter(x -> x.relativePath().endsWith("InputSet.java")).findFirst().get();
        Assertions.assertThat((String)new String(inputSetFile.contents())).containsPattern((CharSequence)"@org\\.eclipse\\.microprofile\\.openapi\\.annotations\\.media\\.Schema\\(.*enumeration");
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void testNSEW_negative(KogitoBuildContext.Builder contextBuilder) {
        contextBuilder.withClassAvailabilityResolver(KogitoContextTestUtils.mockClassAvailabilityResolver(Collections.emptyList(), Collections.singleton("org.eclipse.microprofile.openapi.models.OpenAPI")));
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision-NSEW", contextBuilder);
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((Iterable)generatedFiles).anyMatch(x -> x.relativePath().endsWith("InputSet.java"));
        GeneratedFile inputSetFile = generatedFiles.stream().filter(x -> x.relativePath().endsWith("InputSet.java")).findFirst().get();
        Assertions.assertThat((String)new String(inputSetFile.contents())).doesNotContain(new CharSequence[]{"@org.eclipse.microprofile.openapi.annotations.media.Schema"});
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void pmmlIntegrationTest(KogitoBuildContext.Builder contextBuilder) {
        contextBuilder.withClassAvailabilityResolver(KogitoContextTestUtils.mockClassAvailabilityResolver(Collections.singleton("org.kie.kogito.pmml.AbstractPredictionModels"), Collections.emptyList()));
        this.assertNotEmptySectionCompilationUnit("src/test/resources/decision/models/vacationDays", contextBuilder).contains(new CharSequence[]{"org.kie.kogito.pmml.AbstractPredictionModels.kieRuntimeFactoryFunction"});
        contextBuilder.withClassAvailabilityResolver(KogitoContextTestUtils.mockClassAvailabilityResolver(Collections.emptyList(), Collections.singleton("org.kie.kogito.pmml.AbstractPredictionModels")));
        this.assertNotEmptySectionCompilationUnit("src/test/resources/decision/models/vacationDays", contextBuilder).doesNotContain(new CharSequence[]{"org.kie.kogito.pmml.AbstractPredictionModels.kieRuntimeFactoryFunction"});
    }

    private KogitoBuildContext.Builder stronglyTypedContext(KogitoBuildContext.Builder builder) {
        Properties properties = new Properties();
        properties.put(DecisionCodegen.STRONGLY_TYPED_CONFIGURATION_KEY, Boolean.TRUE.toString());
        builder.withApplicationProperties(properties);
        return builder;
    }

    protected AbstractStringAssert<?> assertNotEmptySectionCompilationUnit(String sourcePath, KogitoBuildContext.Builder contextBuilder) {
        DecisionCodegen codeGenerator = this.getDecisionCodegen(sourcePath, contextBuilder);
        return this.assertNotEmptySectionCompilationUnit(codeGenerator);
    }

    protected AbstractStringAssert<?> assertNotEmptySectionCompilationUnit(DecisionCodegen codeGenerator) {
        Optional optionalApplicationSection = codeGenerator.section();
        Assertions.assertThat((Optional)optionalApplicationSection).isNotEmpty();
        CompilationUnit compilationUnit = ((ApplicationSection)optionalApplicationSection.get()).compilationUnit();
        Assertions.assertThat((Object)compilationUnit).isNotNull();
        return Assertions.assertThat((String)compilationUnit.toString());
    }

    protected DecisionCodegen getDecisionCodegen(String sourcePath, KogitoBuildContext.Builder contextBuilder) {
        return this.getDecisionCodegen(sourcePath, AddonsConfig.DEFAULT, contextBuilder);
    }

    protected DecisionCodegen getDecisionCodegen(String sourcePath, AddonsConfig addonsConfig, KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = this.stronglyTypedContext(contextBuilder).withAddonsConfig(addonsConfig).build();
        return DecisionCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromPaths((Path[])new Path[]{Paths.get(sourcePath, new String[0]).toAbsolutePath()}));
    }

    private Collection<String> fileNames(Collection<GeneratedFile> generatedFiles) {
        return generatedFiles.stream().map(GeneratedFile::relativePath).collect(Collectors.toList());
    }

    private List<GeneratedFile> generateTestDashboards(KogitoBuildContext.Builder contextBuilder, DecisionCodegen codeGenerator) {
        Collection generatedFiles = codeGenerator.generate();
        List<GeneratedFile> dashboards = generatedFiles.stream().filter(x -> x.type().equals(DashboardGeneratedFileUtils.DASHBOARD_TYPE)).collect(Collectors.toList());
        int expectedDashboards = contextBuilder.build().hasRESTForGenerator((Generator)codeGenerator) ? 2 : 0;
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedDashboards, (int)dashboards.size());
        return dashboards;
    }
}

