/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.decision;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Properties;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.codegen.decision.DecisionCodegen;

public class DecisionValidationTest {
    private DecisionCodegen codeGenerator(String path, Consumer<Properties> codeGenContextProperties) throws Exception {
        Properties props = new Properties();
        codeGenContextProperties.accept(props);
        KogitoBuildContext context = JavaKogitoBuildContext.builder().withApplicationProperties(props).build();
        return DecisionCodegen.ofPath((KogitoBuildContext)context, (Path[])new Path[]{Paths.get(path, new String[0]).toAbsolutePath()});
    }

    @Test
    public void testDefault() throws Exception {
        DecisionCodegen codeGenerator = this.codeGenerator("src/test/resources/decision-validation-duplicateName", p -> {});
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> codeGenerator.generate(), (String)"Expected Validation would have failed for defaults.");
    }

    @Test
    public void testIgnore() throws Exception {
        DecisionCodegen codeGenerator = this.codeGenerator("src/test/resources/decision-validation-duplicateName", p -> p.setProperty(DecisionCodegen.VALIDATION_CONFIGURATION_KEY, "IGNORE"));
        Collection files = codeGenerator.generate();
        Assertions.assertThat((Iterable)files).hasSizeGreaterThanOrEqualTo(1);
    }

    @Test
    public void testDisabled() throws Exception {
        DecisionCodegen codeGenerator = this.codeGenerator("src/test/resources/decision-validation-duplicateName", p -> p.setProperty(DecisionCodegen.VALIDATION_CONFIGURATION_KEY, "DISABLED"));
        Collection files = codeGenerator.generate();
        Assertions.assertThat((Iterable)files).hasSizeGreaterThanOrEqualTo(1);
    }

    @Test
    public void testDTAnalysisDefault() throws Exception {
        DecisionCodegen codeGenerator = this.codeGenerator("src/test/resources/decision-validation-DTsemanticError", p -> {});
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> codeGenerator.generate(), (String)"Expected Validation would have failed for defaults.");
    }

    @Test
    public void testDTAnalysisIgnore() throws Exception {
        DecisionCodegen codeGenerator = this.codeGenerator("src/test/resources/decision-validation-DTsemanticError", p -> p.setProperty(DecisionCodegen.VALIDATION_CONFIGURATION_KEY, "IGNORE"));
        Collection files = codeGenerator.generate();
        Assertions.assertThat((Iterable)files).hasSizeGreaterThanOrEqualTo(1);
    }

    @Test
    public void testDTAnalysisDisabled() throws Exception {
        DecisionCodegen codeGenerator = this.codeGenerator("src/test/resources/decision-validation-DTsemanticError", p -> p.setProperty(DecisionCodegen.VALIDATION_CONFIGURATION_KEY, "DISABLED"));
        Collection files = codeGenerator.generate();
        Assertions.assertThat((Iterable)files).hasSizeGreaterThanOrEqualTo(1);
    }
}

