/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.decision;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.junit.jupiter.api.Test;
import org.kie.api.io.ResourceType;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.core.AbstractGenerator;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.decision.DecisionCodegen;

public class DecisionModelResourcesProviderGeneratorTest {
    @Test
    public void generateDecisionModelResourcesProvider() {
        KogitoBuildContext context = QuarkusKogitoBuildContext.builder().withAddonsConfig(AddonsConfig.builder().withTracing(true).build()).build();
        Collection collectedResources = CollectedResourceProducer.fromPaths((Path[])new Path[]{Paths.get("src/test/resources/decision/models/vacationDays", new String[0]).toAbsolutePath(), Paths.get("src/test/resources/decision/models/vacationDaysAlt", new String[0]).toAbsolutePath()});
        long numberOfModels = collectedResources.stream().filter(r -> r.resource().getResourceType() == ResourceType.DMN).count();
        DecisionCodegen codeGenerator = DecisionCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)collectedResources);
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(2);
        List generatedRESTFiles = generatedFiles.stream().filter(gf -> gf.type().equals(AbstractGenerator.REST_TYPE)).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)generatedRESTFiles.isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((long)numberOfModels, (long)generatedRESTFiles.size());
        List generatedCLASSFile = generatedFiles.stream().filter(gf -> gf.type().equals(GeneratedFileType.SOURCE)).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)generatedCLASSFile.size());
        GeneratedFile classFile = (GeneratedFile)generatedCLASSFile.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org/kie/kogito/app/DecisionModelResourcesProvider.java", (Object)classFile.relativePath());
        CompilationUnit compilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(classFile.contents()));
        ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)classDeclaration);
        MethodDeclaration methodDeclaration = (MethodDeclaration)classDeclaration.findFirst(MethodDeclaration.class, d -> d.getName().getIdentifier().equals("getResources")).orElseThrow(() -> new NoSuchElementException("Class declaration doesn't contain a method named \"getResources\"!"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)methodDeclaration);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)methodDeclaration.getBody().isPresent());
        BlockStmt body = (BlockStmt)methodDeclaration.getBody().get();
        org.junit.jupiter.api.Assertions.assertTrue((body.getStatements().size() > 2 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Statement)body.getStatements().get(1)).isExpressionStmt());
        ExpressionStmt expression = (ExpressionStmt)body.getStatements().get(1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(expression.getExpression() instanceof MethodCallExpr));
        MethodCallExpr call = (MethodCallExpr)expression.getExpression();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"add", (Object)call.getName().getIdentifier());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)call.getScope().isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Expression)call.getScope().get()).isNameExpr());
        NameExpr nameExpr = ((Expression)call.getScope().get()).asNameExpr();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"resourcePaths", (Object)nameExpr.getName().getIdentifier());
        long numberOfAddStms = body.getStatements().stream().filter(this::isAddStatement).count();
        org.junit.jupiter.api.Assertions.assertEquals((long)numberOfModels, (long)numberOfAddStms);
        List<NodeList> defaultDecisionModelResources = body.getStatements().stream().filter(this::isAddStatement).map(stm -> stm.asExpressionStmt().getExpression().asMethodCallExpr().getArguments()).collect(Collectors.toList());
        defaultDecisionModelResources.forEach(nodeList -> org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)nodeList.size()));
        Set distinctDefaultDecisionModelResources = defaultDecisionModelResources.stream().map(nodeList -> ((Expression)nodeList.get(0)).toString()).collect(Collectors.toSet());
        org.junit.jupiter.api.Assertions.assertEquals((int)defaultDecisionModelResources.size(), (int)distinctDefaultDecisionModelResources.size());
    }

    private boolean isAddStatement(Statement stm) {
        return stm.isExpressionStmt() && stm.asExpressionStmt().getExpression().isMethodCallExpr() && "add".equals(stm.asExpressionStmt().getExpression().asMethodCallExpr().getName().getIdentifier());
    }
}

