/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.decision;

import com.github.javaparser.ast.CompilationUnit;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.ApplicationSection;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.KogitoContextTestUtils;
import org.kie.kogito.codegen.core.DashboardGeneratedFileUtils;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.decision.DecisionCodegen;
import org.kie.kogito.grafana.JGrafana;

public class DecisionCodegenTest {
    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void generateAllFiles(KogitoBuildContext.Builder contextBuilder) throws Exception {
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision/models/vacationDays", contextBuilder);
        List generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(6);
        Assertions.assertThat(this.fileNames(generatedFiles)).containsAll(Arrays.asList("decision/InputSet.java", "decision/OutputSet.java", "decision/TEmployee.java", "decision/TAddress.java", "decision/TPayroll.java", "decision/VacationsResource.java", "org/kie/kogito/app/DecisionModelResourcesProvider.java"));
        Optional optionalApplicationSection = codeGenerator.section();
        Assertions.assertThat((Optional)optionalApplicationSection).isNotEmpty();
        CompilationUnit compilationUnit = ((ApplicationSection)optionalApplicationSection.get()).compilationUnit();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)compilationUnit);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void doNotGenerateTypesafeInfo(KogitoBuildContext.Builder contextBuilder) throws Exception {
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision/alltypes/", contextBuilder);
        List generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(3);
        Assertions.assertThat(this.fileNames(generatedFiles)).containsAll(Arrays.asList("http_58_47_47www_46trisotech_46com_47definitions_47__4f5608e9_454d74_454c22_45a47e_45ab657257fc9c/InputSet.java", "http_58_47_47www_46trisotech_46com_47definitions_47__4f5608e9_454d74_454c22_45a47e_45ab657257fc9c/OutputSet.java", "http_58_47_47www_46trisotech_46com_47definitions_47__4f5608e9_454d74_454c22_45a47e_45ab657257fc9c/OneOfEachTypeResource.java", "org/kie/kogito/app/DecisionModelResourcesProvider.java"));
        Optional optionalApplicationSection = codeGenerator.section();
        Assertions.assertThat((Optional)optionalApplicationSection).isNotEmpty();
        CompilationUnit compilationUnit = ((ApplicationSection)optionalApplicationSection.get()).compilationUnit();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)compilationUnit);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void givenADMNModelWhenMonitoringIsActiveThenGrafanaDashboardsAreGenerated(KogitoBuildContext.Builder contextBuilder) throws Exception {
        List<GeneratedFile> dashboards = this.generateTestDashboards(AddonsConfig.builder().withMonitoring(true).withPrometheusMonitoring(true).build(), contextBuilder);
        JGrafana vacationOperationalDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("operational-dashboard-Vacations.json")).findFirst().get().contents()));
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)vacationOperationalDashboard.getDashboard().panels.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)vacationOperationalDashboard.getDashboard().links.size());
        JGrafana vacationDomainDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("domain-dashboard-Vacations.json")).findFirst().get().contents()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)vacationDomainDashboard.getDashboard().panels.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)vacationDomainDashboard.getDashboard().links.size());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void givenADMNModelWhenMonitoringAndTracingAreActiveThenTheGrafanaDashboardsContainsTheAuditUILink(KogitoBuildContext.Builder contextBuilder) throws Exception {
        List<GeneratedFile> dashboards = this.generateTestDashboards(AddonsConfig.builder().withMonitoring(true).withPrometheusMonitoring(true).withTracing(true).build(), contextBuilder);
        JGrafana vacationOperationalDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("operational-dashboard-Vacations.json")).findFirst().get().contents()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)vacationOperationalDashboard.getDashboard().links.size());
        JGrafana vacationDomainDashboard = JGrafana.parse((String)new String(dashboards.stream().filter(x -> x.relativePath().contains("domain-dashboard-Vacations.json")).findFirst().get().contents()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)vacationDomainDashboard.getDashboard().links.size());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void resilientToDuplicateDMNIDs(KogitoBuildContext.Builder contextBuilder) throws Exception {
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision-test20200507", contextBuilder);
        List generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(3);
        Optional optionalApplicationSection = codeGenerator.section();
        Assertions.assertThat((Optional)optionalApplicationSection).isNotEmpty();
        CompilationUnit compilationUnit = ((ApplicationSection)optionalApplicationSection.get()).compilationUnit();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)compilationUnit);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void emptyName(KogitoBuildContext.Builder contextBuilder) throws Exception {
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision-empty-name", contextBuilder);
        RuntimeException re = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> ((DecisionCodegen)codeGenerator).generate());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Model name should not be empty", (Object)re.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void testNSEW_positive(KogitoBuildContext.Builder contextBuilder) throws Exception {
        contextBuilder.withClassAvailabilityResolver(KogitoContextTestUtils.mockClassAvailabilityResolver(Collections.singleton("org.eclipse.microprofile.openapi.models.OpenAPI"), Collections.emptyList()));
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision-NSEW", contextBuilder);
        List generatedFiles = codeGenerator.generate();
        Assertions.assertThat((List)generatedFiles).anyMatch(x -> x.relativePath().endsWith("InputSet.java"));
        GeneratedFile inputSetFile = generatedFiles.stream().filter(x -> x.relativePath().endsWith("InputSet.java")).findFirst().get();
        Assertions.assertThat((String)new String(inputSetFile.contents())).containsPattern((CharSequence)"@org\\.eclipse\\.microprofile\\.openapi\\.annotations\\.media\\.Schema\\(.*enumeration");
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void testNSEW_negative(KogitoBuildContext.Builder contextBuilder) throws Exception {
        contextBuilder.withClassAvailabilityResolver(KogitoContextTestUtils.mockClassAvailabilityResolver(Collections.emptyList(), Collections.singleton("org.eclipse.microprofile.openapi.models.OpenAPI")));
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision-NSEW", contextBuilder);
        List generatedFiles = codeGenerator.generate();
        Assertions.assertThat((List)generatedFiles).anyMatch(x -> x.relativePath().endsWith("InputSet.java"));
        GeneratedFile inputSetFile = generatedFiles.stream().filter(x -> x.relativePath().endsWith("InputSet.java")).findFirst().get();
        Assertions.assertThat((String)new String(inputSetFile.contents())).doesNotContain(new CharSequence[]{"@org.eclipse.microprofile.openapi.annotations.media.Schema"});
    }

    private KogitoBuildContext.Builder stronglyTypedContext(KogitoBuildContext.Builder builder) {
        Properties properties = new Properties();
        properties.put(DecisionCodegen.STRONGLY_TYPED_CONFIGURATION_KEY, Boolean.TRUE.toString());
        builder.withApplicationProperties(properties);
        return builder;
    }

    protected DecisionCodegen getDecisionCodegen(String sourcePath, KogitoBuildContext.Builder contextBuilder) {
        return this.getDecisionCodegen(sourcePath, AddonsConfig.DEFAULT, contextBuilder);
    }

    protected DecisionCodegen getDecisionCodegen(String sourcePath, AddonsConfig addonsConfig, KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = this.stronglyTypedContext(contextBuilder).withAddonsConfig(addonsConfig).build();
        return DecisionCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromPaths((Path[])new Path[]{Paths.get(sourcePath, new String[0]).toAbsolutePath()}));
    }

    private List<String> fileNames(List<GeneratedFile> generatedFiles) {
        return generatedFiles.stream().map(GeneratedFile::relativePath).collect(Collectors.toList());
    }

    private List<GeneratedFile> generateTestDashboards(AddonsConfig addonsConfig, KogitoBuildContext.Builder contextBuilder) {
        DecisionCodegen codeGenerator = this.getDecisionCodegen("src/test/resources/decision/models/vacationDays", addonsConfig, contextBuilder);
        List generatedFiles = codeGenerator.generate();
        List<GeneratedFile> dashboards = generatedFiles.stream().filter(x -> x.type().equals(DashboardGeneratedFileUtils.DASHBOARD_TYPE)).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)dashboards.size());
        return dashboards;
    }
}

