/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.decision;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.decision.DecisionCodegen;

class DecisionCloudEventMetaFactoryGeneratorTest {
    private static final String MODEL_PATH = "src/test/resources/decision/models/vacationDays";
    private static final int EXPECTED_FILES_WITH_CLOUDEVENTS = 5;
    private static final int EXPECTED_FILES_WITHOUT_CLOUDEVENTS = 4;
    private static final String EXPECTED_FILE_PATH = "org/kie/kogito/app/DecisionCloudEventMetaFactory.java";

    DecisionCloudEventMetaFactoryGeneratorTest() {
    }

    @Test
    void testGenerateWithCloudEventsEnabled() {
        DecisionCodegen codeGenerator = DecisionCloudEventMetaFactoryGeneratorTest.buildCodegen(true);
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertEquals((int)5, (int)generatedFiles.size());
        Assertions.assertTrue((boolean)generatedFiles.stream().anyMatch(gf -> EXPECTED_FILE_PATH.equals(gf.relativePath())));
    }

    @Test
    void testGenerateWithCloudEventsDisabled() {
        DecisionCodegen codeGenerator = DecisionCloudEventMetaFactoryGeneratorTest.buildCodegen(false);
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertEquals((int)4, (int)generatedFiles.size());
        Assertions.assertFalse((boolean)generatedFiles.stream().anyMatch(gf -> EXPECTED_FILE_PATH.equals(gf.relativePath())));
    }

    private static DecisionCodegen buildCodegen(boolean withCloudEvents) {
        KogitoBuildContext context = QuarkusKogitoBuildContext.builder().withAddonsConfig(AddonsConfig.builder().withCloudEvents(withCloudEvents).build()).build();
        Collection collectedResources = CollectedResourceProducer.fromPaths((Path[])new Path[]{Paths.get(MODEL_PATH, new String[0]).toAbsolutePath()});
        return DecisionCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)collectedResources);
    }
}

