/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.kie.kogito.codegen.openapi.client.OpenApiClientException;
import org.kie.kogito.codegen.openapi.client.OpenApiClientOperation;

public class OpenApiSpecDescriptor {
    private static final String REGEX_NO_EXT = "[.][^.]+$";
    private final String resourceName;
    private final String id;
    private final URI uri;
    private final Set<OpenApiClientOperation> requiredOperations;

    public OpenApiSpecDescriptor(String resource) {
        try {
            this.uri = new URI(resource);
            this.resourceName = Paths.get(this.uri.getPath(), new String[0]).getFileName().toString();
            this.id = OpenApiSpecDescriptor.generateId(this.uri.toString(), this.resourceName);
            this.requiredOperations = new HashSet<OpenApiClientOperation>();
        }
        catch (URISyntaxException e) {
            throw new OpenApiClientException("Fail to parse given resource into URI" + resource, e);
        }
    }

    public OpenApiSpecDescriptor(String resource, String requiredOperationId) {
        this(resource);
        this.requiredOperations.add(new OpenApiClientOperation(requiredOperationId));
    }

    private static String generateId(String resourceUri, String resourceName) {
        return Base64.getEncoder().encodeToString(resourceUri.getBytes(StandardCharsets.UTF_8)) + "_" + resourceName.replaceFirst(REGEX_NO_EXT, "");
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public Set<OpenApiClientOperation> getRequiredOperations() {
        return Collections.unmodifiableSet(this.requiredOperations);
    }

    public void addRequiredOperations(Set<OpenApiClientOperation> operations) {
        this.requiredOperations.addAll(operations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenApiSpecDescriptor that = (OpenApiSpecDescriptor)o;
        return Objects.equals(this.resourceName, that.resourceName) && Objects.equals(this.uri, that.uri) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.resourceName, this.uri, this.id);
    }

    public String toString() {
        return "OpenAPISpecResource{resourceName='" + this.resourceName + "', uri=" + this.uri + ", id='" + this.id + "'}";
    }
}

