/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client.io;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecMockServer;
import org.kie.kogito.codegen.openapi.client.io.ClasspathResolver;
import org.kie.kogito.codegen.openapi.client.io.FileResolver;
import org.kie.kogito.codegen.openapi.client.io.HTTPResolver;
import org.kie.kogito.codegen.openapi.client.io.PathResolver;
import org.kie.kogito.codegen.openapi.client.io.PathResolverFactory;

class PathResolverTest {
    PathResolverTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void verifyClasspathResolver(KogitoBuildContext.Builder contextBuilder) {
        String[] resources = new String[]{"specs/__files/petstore.json", "classpath://specs/__files/petstore.json"};
        KogitoBuildContext context = contextBuilder.build();
        for (String resource : resources) {
            OpenApiSpecDescriptor openApiSpecDescriptor = new OpenApiSpecDescriptor(resource);
            PathResolver resolver = PathResolverFactory.newResolver((OpenApiSpecDescriptor)openApiSpecDescriptor, (KogitoBuildContext)context);
            Assertions.assertThat((Object)resolver).isInstanceOf(ClasspathResolver.class);
            String path = resolver.resolve(openApiSpecDescriptor);
            this.assertResolverPath(path);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void verifyFileResolver(KogitoBuildContext.Builder contextBuilder) {
        String resource = "specs/__files/petstore.json";
        KogitoBuildContext context = contextBuilder.build();
        String classpathPath = Objects.requireNonNull(this.getClass().getClassLoader().getResource("specs/__files/petstore.json")).getPath();
        OpenApiSpecDescriptor openApiSpecDescriptor = new OpenApiSpecDescriptor("file://" + classpathPath);
        PathResolver resolver = PathResolverFactory.newResolver((OpenApiSpecDescriptor)openApiSpecDescriptor, (KogitoBuildContext)context);
        Assertions.assertThat((Object)resolver).isInstanceOf(FileResolver.class);
        String path = resolver.resolve(openApiSpecDescriptor);
        this.assertResolverPath(path);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    @ExtendWith(value={OpenApiSpecMockServer.class})
    void verifyHTTPResolver(KogitoBuildContext.Builder contextBuilder) {
        String resource = "http://localhost:8989/petstore.json";
        KogitoBuildContext context = contextBuilder.build();
        OpenApiSpecDescriptor openApiSpecDescriptor = new OpenApiSpecDescriptor("http://localhost:8989/petstore.json");
        PathResolver resolver = PathResolverFactory.newResolver((OpenApiSpecDescriptor)openApiSpecDescriptor, (KogitoBuildContext)context);
        Assertions.assertThat((Object)resolver).isInstanceOf(HTTPResolver.class);
        String path = resolver.resolve(openApiSpecDescriptor);
        this.assertResolverPath(path);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    @ExtendWith(value={OpenApiSpecMockServer.class})
    void verifyHTTPResolverWithError(KogitoBuildContext.Builder contextBuilder) {
        String resource = "http://localhost:8989/error.json";
        KogitoBuildContext context = contextBuilder.build();
        OpenApiSpecDescriptor openApiSpecDescriptor = new OpenApiSpecDescriptor("http://localhost:8989/error.json");
        PathResolver resolver = PathResolverFactory.newResolver((OpenApiSpecDescriptor)openApiSpecDescriptor, (KogitoBuildContext)context);
        Assertions.assertThat((Object)resolver).isInstanceOf(HTTPResolver.class);
        IllegalArgumentException resolverEx = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> resolver.resolve(openApiSpecDescriptor));
        Assertions.assertThat((String)resolverEx.getMessage()).contains(new CharSequence[]{"is not supported for the operation"});
    }

    void assertResolverPath(String actual) {
        Assertions.assertThat((String)actual).isNotEmpty();
        Assertions.assertThat((String)actual).endsWith((CharSequence)"petstore.json");
        Assertions.assertThat((boolean)Files.exists(Paths.get(actual, new String[0]), new LinkOption[0])).isTrue();
    }
}

