/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.kie.kogito.codegen.openapi.client.OpenApiUtils;
import org.kie.kogito.codegen.openapi.client.io.AbstractPathResolver;

public class HTTPResolver
extends AbstractPathResolver {
    private static final String ACCEPT_HEADERS = "application/json,application/yaml,application/yml,application/text,text/*,*/*";

    protected HTTPResolver(KogitoBuildContext context) {
        super(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String resolve(OpenApiSpecDescriptor resource) {
        OpenApiUtils.requireValidSpecURI(resource);
        try {
            URL openAPISpecFileURL = resource.getURI().toURL();
            HttpURLConnection conn = (HttpURLConnection)openAPISpecFileURL.openConnection();
            conn.setRequestProperty("Accept", ACCEPT_HEADERS);
            int respCode = conn.getResponseCode();
            if (respCode == 200) {
                try (InputStream is = conn.getInputStream();){
                    String string = this.saveFileToTempLocation(resource, is);
                    return string;
                }
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            try {
                StringBuilder response = new StringBuilder();
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        throw new IllegalArgumentException(String.format("Failed to fetch remote OpenAPI spec file: %s. Status code is %d and response: \n %s", resource.getURI().toString(), respCode, response));
                    }
                    response.append(line);
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to resolve remote file: " + resource.getURI().toString(), e);
        }
    }
}

