/*
 * Copyright 2022 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.kogito.codegen.openapi.client;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OpenApiSpecDescriptorTest {

    @Test
    void verifyDocumentWithSpecialCharacters() {
        final OpenApiSpecDescriptor descriptor = new OpenApiSpecDescriptor("myfile.2.0.yaml");
        Assertions.assertThat(descriptor.getId()).endsWith("myfile");
        Assertions.assertThat(descriptor.getResourceName()).isEqualTo("myfile.yaml");
    }

}