/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client.generator;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.kogito.codegen.openapi.client.OpenApiClientOperation;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.api.TemplateFileType;
import org.openapitools.codegen.languages.JavaClientCodegen;

public class KogitoJavaClientCodegen
extends JavaClientCodegen {
    private static final String CUSTOM_TEMPLATES = "custom-templates/resteasy";
    private static final String CUSTOM_API_CLIENT_TEMPLATE = "kogitoApiClient.mustache";
    private static final String CUSTOM_API_CLIENT_FILENAME = "KogitoApiClient.java";
    private final DefaultGenerator generator;

    protected KogitoJavaClientCodegen(DefaultGenerator generator) {
        this.generator = generator;
        this.generator.setGeneratorPropertyDefault("models", "false");
        this.setLibrary("resteasy");
        this.setTemplateDir(CUSTOM_TEMPLATES);
        this.setDateLibrary("java8");
        this.setUseRuntimeException(true);
    }

    protected void processGeneratedOperations(OpenApiSpecDescriptor descriptor) {
        Map paths = this.generator.processPaths(this.openAPI.getPaths());
        paths.forEach((api, operations) -> operations.forEach(operation -> descriptor.getRequiredOperations().stream().filter(resourceOperation -> resourceOperation.getOperationId().equals(operation.operationId)).findFirst().ifPresent(resourceOperation -> {
            resourceOperation.setApi((String)api);
            resourceOperation.setMethodName(operation.operationId);
            resourceOperation.setGeneratedClass(this.apiPackage + "." + this.toApiName((String)api));
            if (operation.hasParams) {
                for (int i = 0; i < operation.allParams.size(); ++i) {
                    resourceOperation.addParameter(OpenApiClientOperation.newParameter(i, ((CodegenParameter)operation.allParams.get((int)i)).paramName));
                }
            }
        })));
        List nonProcessedOps = descriptor.getRequiredOperations().stream().filter(ro -> ro.getGeneratedClass() == null || ro.getMethodName() == null).collect(Collectors.toList());
        if (!nonProcessedOps.isEmpty()) {
            throw new IllegalArgumentException("Required Operations " + nonProcessedOps + " not found in the processed spec " + descriptor.getResourceName() + ". Available operations are " + this.collectCodegenOperations(paths));
        }
    }

    private List<String> collectCodegenOperations(Map<String, List<CodegenOperation>> paths) {
        return paths.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).map(o -> o.operationId).collect(Collectors.toList());
    }

    public void processOpts() {
        super.processOpts();
        SupportingFile apiClientFile = this.supportingFiles().stream().filter(f -> f.getTemplateType() == TemplateFileType.SupportingFiles && f.getDestinationFilename().equals("ApiClient.java")).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't find ApiClient.java supporting file, impossible to generate OpenApi Client application"));
        this.supportingFiles().add(new SupportingFile(CUSTOM_API_CLIENT_TEMPLATE, apiClientFile.getFolder(), CUSTOM_API_CLIENT_FILENAME));
    }

    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        objs.put("useRuntimeException", true);
        return super.postProcessSupportingFileData(objs);
    }

    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        super.postProcessOperationsWithModels(objs, allModels);
        List imports = (List)objs.get("imports");
        Iterator itr = imports.iterator();
        while (itr.hasNext()) {
            String itrImport = (String)((Map)itr.next()).get("import");
            if (!itrImport.contains(".model.")) continue;
            itr.remove();
        }
        return objs;
    }
}

