/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client.io;

import java.util.Objects;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.kie.kogito.codegen.openapi.client.io.ClasspathResolver;
import org.kie.kogito.codegen.openapi.client.io.FileResolver;
import org.kie.kogito.codegen.openapi.client.io.HTTPResolver;
import org.kie.kogito.codegen.openapi.client.io.PathResolver;

public final class PathResolverFactory {
    static final String CLASSPATH = "classpath";
    static final String FILE = "file";
    static final String HTTP = "http";
    static final String HTTPS = "https";

    private PathResolverFactory() {
    }

    public static PathResolver newResolver(OpenApiSpecDescriptor resource, KogitoBuildContext context) {
        Objects.requireNonNull(resource);
        if (!resource.getURI().isAbsolute()) {
            return new ClasspathResolver(context);
        }
        switch (resource.getURI().getScheme()) {
            case "classpath": {
                return new ClasspathResolver(context);
            }
            case "file": {
                return new FileResolver(context);
            }
            case "http": 
            case "https": {
                return new HTTPResolver(context);
            }
        }
        throw new IllegalArgumentException("URI schema not supported to resolve OpenAPI spec file. Supported schemas are http, file or classpath");
    }
}

