/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.MergeUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;

public class MergeUtilsTest {
    @Test
    void testSrcTargetArray() {
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)JsonObjectUtils.toJavaValue((JsonNode)MergeUtils.merge((JsonNode)ObjectMapperFactory.get().createArrayNode().add(4).add(5).add(6), (JsonNode)ObjectMapperFactory.get().createArrayNode().add(1).add(2).add(3), (boolean)true)));
    }

    @Test
    void testTargetArraySrcInt() {
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4), (Object)JsonObjectUtils.toJavaValue((JsonNode)MergeUtils.merge((JsonNode)new IntNode(4), (JsonNode)ObjectMapperFactory.get().createArrayNode().add(1).add(2).add(3))));
    }

    @Test
    void testTargetIntSrcArray() {
        Assertions.assertEquals(Arrays.asList(4, 1, 2, 3), (Object)JsonObjectUtils.toJavaValue((JsonNode)MergeUtils.merge((JsonNode)ObjectMapperFactory.get().createArrayNode().add(1).add(2).add(3), (JsonNode)new IntNode(4), (boolean)false)));
    }

    @Test
    void testTargetObjectSrcInt() {
        Assertions.assertEquals(Collections.singletonMap("response", 3), (Object)JsonObjectUtils.toJavaValue((JsonNode)MergeUtils.merge((JsonNode)new IntNode(3), (JsonNode)ObjectMapperFactory.get().createObjectNode(), (boolean)false)));
    }

    @Test
    void testTargetObjectSrcArray() {
        Assertions.assertEquals(Collections.singletonMap("response", Arrays.asList(1, 2, 3)), (Object)JsonObjectUtils.toJavaValue((JsonNode)MergeUtils.merge((JsonNode)ObjectMapperFactory.get().createArrayNode().add(1).add(2).add(3), (JsonNode)ObjectMapperFactory.get().createObjectNode(), (boolean)false)));
    }

    @Test
    void testObjectMerge() {
        ObjectNode dummyCustomer = MergeUtilsTest.getCustomer("Fulanito", 23, 999.9, false, "Parla", Arrays.asList("percebe 13", "casa de mis padres en Mostoles"));
        ObjectNode vipCustomer = MergeUtilsTest.getCustomer("Messi", 69, 1221312.2, true, "Islas virgenes", Arrays.asList("Isla paradisiaca anonima", "Palacio presidencial S/N"));
        JsonNode merged = MergeUtils.merge((JsonNode)ObjectMapperFactory.get().createObjectNode().set("dummyCustomer", (JsonNode)dummyCustomer), (JsonNode)ObjectMapperFactory.get().createObjectNode().set("vipCustomer", (JsonNode)vipCustomer));
        Assertions.assertEquals((Object)dummyCustomer, (Object)merged.get("dummyCustomer"));
        Assertions.assertEquals((Object)vipCustomer, (Object)merged.get("vipCustomer"));
    }

    @Test
    void testOverlapObjectMerge() {
        ObjectNode dummyCustomer = MergeUtilsTest.getCustomer("Fulanito", 23, 999.9, false, "Parla", Arrays.asList("percebe 13", "casa de mis padres en Mostoles"));
        ObjectNode vipCustomer = MergeUtilsTest.getCustomer("Messi", 69, 1221312.2, true, "Parla", Arrays.asList("Isla paradisiaca anonima", "Palacio presidencial S/N"));
        ObjectNode expectedMerged = MergeUtilsTest.getCustomer("Fulanito", 23, 999.9, false, "Parla", Arrays.asList("Isla paradisiaca anonima", "Palacio presidencial S/N", "percebe 13", "casa de mis padres en Mostoles"));
        Assertions.assertEquals((Object)expectedMerged, (Object)MergeUtils.merge((JsonNode)dummyCustomer, (JsonNode)vipCustomer, (boolean)true));
    }

    @Test
    void testObjectArrayMerge() {
        ObjectNode dummyCustomer = MergeUtilsTest.getCustomer("Fulanito", 23, 999.9, false, "Parla", Arrays.asList("percebe 13", "casa de mis padres en Mostoles"));
        ObjectNode vipCustomer = MergeUtilsTest.getCustomer("Messi", 69, 1221312.2, true, "Islas Virgenes", Arrays.asList("Isla paradisiaca anonima", "Palacio presidencial S/N"));
        ArrayNode merged = (ArrayNode)MergeUtils.merge((JsonNode)ObjectMapperFactory.get().createArrayNode().add((JsonNode)dummyCustomer), (JsonNode)ObjectMapperFactory.get().createArrayNode().add((JsonNode)vipCustomer), (boolean)true);
        Assertions.assertEquals((int)2, (int)merged.size());
        Assertions.assertEquals((Object)vipCustomer, (Object)merged.get(0));
        Assertions.assertEquals((Object)dummyCustomer, (Object)merged.get(1));
    }

    @Test
    void testObjectArrayMergeNoDuplicate() {
        ObjectNode dummyCustomer = MergeUtilsTest.getCustomer("Fulanito", 23, 999.9, false, "Parla", Arrays.asList("percebe 13", "casa de mis padres en Mostoles"));
        ObjectNode vipCustomer = MergeUtilsTest.getCustomer("Messi", 69, 1221312.2, true, "Islas Virgenes", Arrays.asList("Isla paradisiaca anonima", "Palacio presidencial S/N"));
        ArrayNode merged = (ArrayNode)MergeUtils.merge((JsonNode)ObjectMapperFactory.get().createArrayNode().add((JsonNode)dummyCustomer), (JsonNode)ObjectMapperFactory.get().createArrayNode().add((JsonNode)vipCustomer).add((JsonNode)dummyCustomer), (boolean)true);
        Assertions.assertEquals((int)2, (int)merged.size());
        Assertions.assertEquals((Object)vipCustomer, (Object)merged.get(0));
        Assertions.assertEquals((Object)dummyCustomer, (Object)merged.get(1));
    }

    @Test
    void testNullMerge() {
        ObjectNode srcNode = ObjectMapperFactory.get().createObjectNode().put("name", "javierito");
        Assertions.assertEquals((Object)srcNode, (Object)MergeUtils.merge((JsonNode)srcNode, null));
    }

    @Test
    void testMergeWithPojo() {
        Person person = new Person("javierito");
        ObjectNode target = ObjectMapperFactory.get().createObjectNode().put("name", "fulanito");
        Assertions.assertEquals((Object)ObjectMapperFactory.get().createObjectNode().put("name", "javierito"), (Object)MergeUtils.merge((JsonNode)JsonObjectUtils.fromValue((Object)person), (JsonNode)target));
    }

    private static ObjectNode getCustomer(String name, int age, double salary, boolean hasJob, String city, Iterable<String> addresses) {
        ArrayNode addressesArray = ObjectMapperFactory.get().createArrayNode();
        for (String address : addresses) {
            addressesArray.add((JsonNode)ObjectMapperFactory.get().createObjectNode().put("address", address).put("city", city));
        }
        return (ObjectNode)ObjectMapperFactory.get().createObjectNode().put("name", name).put("age", age).put("salary", salary).put("hasJob", hasJob).set("addresses", (JsonNode)addressesArray);
    }

    private static class Person {
        private String name;

        public Person() {
        }

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

