/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.MergeUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;

public class MergeUtilsTest {
    @Test
    void testSrcTargetArray() {
        Assertions.assertThat((Object)JsonObjectUtils.toJavaValue((JsonNode)MergeUtils.merge((JsonNode)ObjectMapperFactory.get().createArrayNode().add(4).add(5).add(6), (JsonNode)ObjectMapperFactory.get().createArrayNode().add(1).add(2).add(3), (boolean)true))).isEqualTo(Arrays.asList(1, 2, 3, 4, 5, 6));
    }

    @Test
    void testTargetArraySrcInt() {
        Assertions.assertThat((Object)JsonObjectUtils.toJavaValue((JsonNode)MergeUtils.merge((JsonNode)new IntNode(4), (JsonNode)ObjectMapperFactory.get().createArrayNode().add(1).add(2).add(3)))).isEqualTo(Arrays.asList(1, 2, 3, 4));
    }

    @Test
    void testTargetIntSrcArray() {
        Assertions.assertThat((Object)JsonObjectUtils.toJavaValue((JsonNode)MergeUtils.merge((JsonNode)ObjectMapperFactory.get().createArrayNode().add(1).add(2).add(3), (JsonNode)new IntNode(4), (boolean)false))).isEqualTo(Arrays.asList(4, 1, 2, 3));
    }

    @Test
    void testTargetObjectSrcInt() {
        Assertions.assertThat((Object)JsonObjectUtils.toJavaValue((JsonNode)MergeUtils.merge((JsonNode)new IntNode(3), (JsonNode)ObjectMapperFactory.get().createObjectNode(), (boolean)false))).isEqualTo(Collections.singletonMap("response", 3));
    }

    @Test
    void testTargetObjectSrcArray() {
        Assertions.assertThat((Object)JsonObjectUtils.toJavaValue((JsonNode)MergeUtils.merge((JsonNode)ObjectMapperFactory.get().createArrayNode().add(1).add(2).add(3), (JsonNode)ObjectMapperFactory.get().createObjectNode(), (boolean)false))).isEqualTo(Collections.singletonMap("response", Arrays.asList(1, 2, 3)));
    }

    @Test
    void testObjectMerge() {
        ObjectNode dummyCustomer = MergeUtilsTest.getCustomer("Fulanito", 23, 999.9, false, "Parla", Arrays.asList("percebe 13", "casa de mis padres en Mostoles"));
        ObjectNode vipCustomer = MergeUtilsTest.getCustomer("Messi", 69, 1221312.2, true, "Islas virgenes", Arrays.asList("Isla paradisiaca anonima", "Palacio presidencial S/N"));
        JsonNode merged = MergeUtils.merge((JsonNode)ObjectMapperFactory.get().createObjectNode().set("dummyCustomer", (JsonNode)dummyCustomer), (JsonNode)ObjectMapperFactory.get().createObjectNode().set("vipCustomer", (JsonNode)vipCustomer));
        Assertions.assertThat((Iterable)merged.get("dummyCustomer")).isEqualTo((Object)dummyCustomer);
        Assertions.assertThat((Iterable)merged.get("vipCustomer")).isEqualTo((Object)vipCustomer);
    }

    @Test
    void testOverlapObjectMerge() {
        ObjectNode dummyCustomer = MergeUtilsTest.getCustomer("Fulanito", 23, 999.9, false, "Parla", Arrays.asList("percebe 13", "casa de mis padres en Mostoles"));
        ObjectNode vipCustomer = MergeUtilsTest.getCustomer("Messi", 69, 1221312.2, true, "Parla", Arrays.asList("Isla paradisiaca anonima", "Palacio presidencial S/N"));
        ObjectNode expectedMerged = MergeUtilsTest.getCustomer("Fulanito", 23, 999.9, false, "Parla", Arrays.asList("Isla paradisiaca anonima", "Palacio presidencial S/N", "percebe 13", "casa de mis padres en Mostoles"));
        Assertions.assertThat((Iterable)MergeUtils.merge((JsonNode)dummyCustomer, (JsonNode)vipCustomer, (boolean)true)).isEqualTo((Object)expectedMerged);
    }

    @Test
    void testObjectArrayMerge() {
        ObjectNode dummyCustomer = MergeUtilsTest.getCustomer("Fulanito", 23, 999.9, false, "Parla", Arrays.asList("percebe 13", "casa de mis padres en Mostoles"));
        ObjectNode vipCustomer = MergeUtilsTest.getCustomer("Messi", 69, 1221312.2, true, "Islas Virgenes", Arrays.asList("Isla paradisiaca anonima", "Palacio presidencial S/N"));
        ArrayNode merged = (ArrayNode)MergeUtils.merge((JsonNode)ObjectMapperFactory.get().createArrayNode().add((JsonNode)dummyCustomer), (JsonNode)ObjectMapperFactory.get().createArrayNode().add((JsonNode)vipCustomer), (boolean)true);
        Assertions.assertThat((int)merged.size()).isEqualTo(2);
        Assertions.assertThat((Iterable)merged.get(0)).isEqualTo((Object)vipCustomer);
        Assertions.assertThat((Iterable)merged.get(1)).isEqualTo((Object)dummyCustomer);
    }

    @Test
    void testObjectArrayMergeNoDuplicate() {
        ObjectNode dummyCustomer = MergeUtilsTest.getCustomer("Fulanito", 23, 999.9, false, "Parla", Arrays.asList("percebe 13", "casa de mis padres en Mostoles"));
        ObjectNode vipCustomer = MergeUtilsTest.getCustomer("Messi", 69, 1221312.2, true, "Islas Virgenes", Arrays.asList("Isla paradisiaca anonima", "Palacio presidencial S/N"));
        ArrayNode merged = (ArrayNode)MergeUtils.merge((JsonNode)ObjectMapperFactory.get().createArrayNode().add((JsonNode)dummyCustomer), (JsonNode)ObjectMapperFactory.get().createArrayNode().add((JsonNode)vipCustomer).add((JsonNode)dummyCustomer), (boolean)true);
        Assertions.assertThat((int)merged.size()).isEqualTo(2);
        Assertions.assertThat((Iterable)merged.get(0)).isEqualTo((Object)vipCustomer);
        Assertions.assertThat((Iterable)merged.get(1)).isEqualTo((Object)dummyCustomer);
    }

    @Test
    void testNullMerge() {
        ObjectNode srcNode = ObjectMapperFactory.get().createObjectNode().put("name", "javierito");
        Assertions.assertThat((Iterable)MergeUtils.merge((JsonNode)srcNode, null)).isEqualTo((Object)srcNode);
    }

    @Test
    void testMergeWithPojo() {
        Person person = new Person("javierito");
        ObjectNode target = ObjectMapperFactory.get().createObjectNode().put("name", "fulanito");
        Assertions.assertThat((Iterable)MergeUtils.merge((JsonNode)JsonObjectUtils.fromValue((Object)person), (JsonNode)target)).isEqualTo((Object)ObjectMapperFactory.get().createObjectNode().put("name", "javierito"));
    }

    private static ObjectNode getCustomer(String name, int age, double salary, boolean hasJob, String city, Iterable<String> addresses) {
        ArrayNode addressesArray = ObjectMapperFactory.get().createArrayNode();
        for (String address : addresses) {
            addressesArray.add((JsonNode)ObjectMapperFactory.get().createObjectNode().put("address", address).put("city", city));
        }
        return (ObjectNode)ObjectMapperFactory.get().createObjectNode().put("name", name).put("age", age).put("salary", salary).put("hasJob", hasJob).set("addresses", (JsonNode)addressesArray);
    }

    private static class Person {
        private String name;

        public Person() {
        }

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

