/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.process.expr.Expression;
import org.kie.kogito.process.expr.ExpressionHandlerFactory;

class JqExpressionHandlerTest {
    private KogitoProcessContext context;

    JqExpressionHandlerTest() {
    }

    @Test
    void testStringExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".foo");
        ObjectNode node = new ObjectMapper().createObjectNode().put("foo", "javierito");
        Assertions.assertEquals((Object)"javierito", (Object)parsedExpression.eval((Object)node, String.class, this.context));
    }

    @Test
    void testBooleanExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".foo");
        ObjectNode node = new ObjectMapper().createObjectNode().put("foo", true);
        Assertions.assertTrue((boolean)((Boolean)parsedExpression.eval((Object)node, Boolean.class, this.context)));
    }

    @Test
    void testNumericExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".number*.number");
        ObjectNode node = new ObjectMapper().createObjectNode().put("number", 2);
        Assertions.assertEquals((int)4, (int)((JsonNode)parsedExpression.eval((Object)node, JsonNode.class, this.context)).asInt());
    }

    @Test
    void testNumericAssignment() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)"{\"result\" : .number*.number}");
        ObjectNode node = new ObjectMapper().createObjectNode().put("number", 2);
        Assertions.assertEquals((int)4, (int)((JsonNode)parsedExpression.eval((Object)node, JsonNode.class, this.context)).get("result").asInt());
    }

    @Test
    void testJsonNodeExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".foo");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.createObjectNode().set("foo", (JsonNode)mapper.createObjectNode().put("name", "Javierito"));
        Assertions.assertEquals((Object)"Javierito", (Object)((ObjectNode)parsedExpression.eval((Object)node, ObjectNode.class, this.context)).get("name").asText());
    }

    @Test
    void testMultiExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".foo,.main,.another");
        ObjectNode node = new ObjectMapper().createObjectNode().put("foo", "Javierito").put("main", "Pepito").put("another", "Fulanito");
        Assertions.assertEquals((Object)"Javierito Pepito Fulanito", (Object)parsedExpression.eval((Object)node, String.class, this.context));
    }

    @Test
    void testCollection() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".foo");
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode node = objectMapper.createObjectNode().set("foo", (JsonNode)objectMapper.createArrayNode().add("pepe").add(false).add(3).add((JsonNode)objectMapper.createArrayNode().add(1.1).add(1.2).add(1.3)));
        Assertions.assertEquals(Arrays.asList("pepe", false, 3, Arrays.asList(1.1, 1.2, 1.3)), (Object)parsedExpression.eval((Object)node, Collection.class, this.context));
    }
}

