/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Output;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.process.expr.Expression;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JqExpression
implements Expression {
    private static final Logger logger = LoggerFactory.getLogger(JqExpression.class);
    private final Supplier<Scope> scope;
    private final String expr;
    private JsonQuery query;
    private String compiledExpr;

    public JqExpression(Supplier<Scope> scope, String expr) {
        this.expr = expr;
        this.compiledExpr = expr;
        this.scope = scope;
    }

    private <T> TypedOutput<T> output(Class<T> returnClass) {
        TypedOutput<Boolean> out = Boolean.class.isAssignableFrom(returnClass) ? new BooleanOutput() : (String.class.isAssignableFrom(returnClass) ? new StringOutput() : (Collection.class.isAssignableFrom(returnClass) ? new CollectionOutput() : new JsonNodeOutput()));
        return out;
    }

    public <T> T eval(Object target, Class<T> returnClass, KogitoProcessContext context) {
        return this.eval(JsonObjectUtils.fromValue((Object)target), returnClass, context);
    }

    public void assign(Object target, Object value, KogitoProcessContext context) {
        JsonNode targetNode = JsonObjectUtils.fromValue((Object)target);
        ExpressionHandlerUtils.assign((JsonNode)targetNode, (JsonNode)this.eval(targetNode, JsonNode.class, context), (JsonNode)JsonObjectUtils.fromValue((Object)value), (String)this.expr);
    }

    private <T> T eval(JsonNode context, Class<T> returnClass, KogitoProcessContext processInfo) {
        try {
            TypedOutput<T> output = this.output(returnClass);
            this.compile(Optional.ofNullable(processInfo));
            this.query.apply(this.scope.get(), context, output);
            return output.getResult();
        }
        catch (JsonQueryException e) {
            throw new IllegalArgumentException("Unable to evaluate content " + context + " using expr " + this.expr, e);
        }
    }

    private void compile(Optional<KogitoProcessContext> context) throws JsonQueryException {
        String resolvedExpr = ExpressionHandlerUtils.prepareExpr((String)this.expr, context);
        logger.debug("Resolved expr {}", (Object)resolvedExpr);
        if (this.query == null || !resolvedExpr.equals(this.compiledExpr)) {
            this.compiledExpr = resolvedExpr;
            logger.debug("Compiled expr {}", (Object)this.compiledExpr);
            this.query = JsonQuery.compile((String)this.compiledExpr, (Version)Versions.JQ_1_6);
        }
    }

    public boolean isValid(Optional<KogitoProcessContext> context) {
        try {
            this.compile(context);
            if (this.isConstantString()) {
                this.query.apply(this.scope.get(), (JsonNode)NullNode.instance, this.output(JsonNode.class));
            }
            return true;
        }
        catch (JsonQueryException e) {
            return false;
        }
    }

    private boolean isConstantString() {
        return this.compiledExpr.chars().allMatch(Character::isJavaIdentifierPart);
    }

    public String asString() {
        return this.expr;
    }

    private static class JsonNodeOutput
    implements TypedOutput<JsonNode> {
        private JsonNode result;
        private boolean arrayCreated;

        private JsonNodeOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            if (this.result == null) {
                this.result = out;
            } else if (!this.arrayCreated) {
                ArrayNode newNode = ObjectMapperFactory.get().createArrayNode();
                newNode.add(this.result).add(out);
                this.result = newNode;
                this.arrayCreated = true;
            } else {
                ((ArrayNode)this.result).add(out);
            }
        }

        @Override
        public JsonNode getResult() {
            return this.result;
        }
    }

    private static class CollectionOutput
    implements TypedOutput<Collection> {
        Collection result = new ArrayList();

        private CollectionOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            Object obj = JsonObjectUtils.toJavaValue((JsonNode)out);
            if (obj instanceof Collection) {
                this.result.addAll((Collection)obj);
            } else {
                this.result.add(obj);
            }
        }

        @Override
        public Collection<?> getResult() {
            return this.result;
        }
    }

    private static class StringOutput
    implements TypedOutput<String> {
        StringBuilder sb = new StringBuilder();

        private StringOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            if (this.sb.length() > 0) {
                this.sb.append(' ');
            }
            this.sb.append(out.asText());
        }

        @Override
        public String getResult() {
            return this.sb.toString();
        }
    }

    private static class BooleanOutput
    implements TypedOutput<Boolean> {
        boolean result;

        private BooleanOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            this.result = out.asBoolean();
        }

        @Override
        public Boolean getResult() {
            return this.result;
        }
    }

    private static interface TypedOutput<T>
    extends Output {
        public T getResult();
    }
}

