/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Output;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.kie.kogito.expr.jq.FunctionJsonNode;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.process.expr.Expression;
import org.kie.kogito.serverless.workflow.utils.ExpressionHandlerUtils;

public class JqExpression
implements Expression {
    private final Supplier<Scope> scope;
    private final String expr;
    private JsonQuery query;

    public JqExpression(Supplier<Scope> scope, String expr) {
        this.expr = expr;
        this.scope = scope;
    }

    private TypedOutput output(Class<?> returnClass) {
        TypedOutput out = String.class.isAssignableFrom(returnClass) ? new StringOutput() : (Collection.class.isAssignableFrom(returnClass) ? new CollectionOutput() : new JsonNodeOutput());
        return out;
    }

    public <T> T eval(Object target, Class<T> returnClass, KogitoProcessContext context) {
        return this.eval(JsonObjectUtils.fromValue((Object)target), returnClass, context);
    }

    public void assign(Object target, Object value, KogitoProcessContext context) {
        JsonNode targetNode = JsonObjectUtils.fromValue((Object)target);
        ExpressionHandlerUtils.assign((JsonNode)targetNode, (JsonNode)this.eval(targetNode, JsonNode.class, context), (JsonNode)JsonObjectUtils.fromValue((Object)value), (String)this.expr);
    }

    private Scope getScope(KogitoProcessContext processInfo) {
        Scope childScope = Scope.newChildScope((Scope)this.scope.get());
        childScope.setValue("SECRET", (JsonNode)new FunctionJsonNode(ExpressionHandlerUtils::getSecret));
        childScope.setValue("WORKFLOW", (JsonNode)new FunctionJsonNode(ExpressionHandlerUtils.getContextFunction((KogitoProcessContext)processInfo)));
        childScope.setValue("CONST", ExpressionHandlerUtils.getConstants((KogitoProcessContext)processInfo));
        return childScope;
    }

    private <T> T eval(JsonNode context, Class<T> returnClass, KogitoProcessContext processInfo) {
        try {
            TypedOutput output = this.output(returnClass);
            this.compile();
            this.query.apply(this.getScope(processInfo), context, (Output)output);
            return (T)JsonObjectUtils.convertValue((Object)output.getResult(), returnClass);
        }
        catch (JsonQueryException e) {
            throw new IllegalArgumentException("Unable to evaluate content " + context + " using expr " + this.expr, e);
        }
    }

    private void compile() throws JsonQueryException {
        if (this.query == null) {
            this.query = JsonQuery.compile((String)this.expr, (Version)Versions.JQ_1_6);
        }
    }

    public boolean isValid() {
        try {
            this.compile();
            return true;
        }
        catch (JsonQueryException e) {
            return false;
        }
    }

    public String asString() {
        return this.expr;
    }

    private static class JsonNodeOutput
    implements TypedOutput {
        private JsonNode result;
        private boolean arrayCreated;

        private JsonNodeOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            if (this.result == null) {
                this.result = out;
            } else if (!this.arrayCreated) {
                ArrayNode newNode = ObjectMapperFactory.get().createArrayNode();
                newNode.add(this.result).add(out);
                this.result = newNode;
                this.arrayCreated = true;
            } else {
                ((ArrayNode)this.result).add(out);
            }
        }

        public JsonNode getResult() {
            return this.result;
        }
    }

    private static class CollectionOutput
    implements TypedOutput {
        Collection<Object> result = new ArrayList<Object>();

        private CollectionOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            Object obj = JsonObjectUtils.toJavaValue((JsonNode)out);
            if (obj instanceof Collection) {
                this.result.addAll((Collection)obj);
            } else {
                this.result.add(obj);
            }
        }

        @Override
        public Object getResult() {
            return this.result;
        }
    }

    private static class StringOutput
    implements TypedOutput {
        StringBuilder sb = new StringBuilder();

        private StringOutput() {
        }

        public void emit(JsonNode out) throws JsonQueryException {
            if (this.sb.length() > 0) {
                this.sb.append(' ');
            }
            this.sb.append(out.asText());
        }

        @Override
        public Object getResult() {
            return this.sb.toString();
        }
    }

    private static interface TypedOutput
    extends Output {
        public Object getResult();
    }
}

