/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.process.expr.Expression;
import org.kie.kogito.process.expr.ExpressionHandlerFactory;
import org.kie.kogito.serverless.workflow.test.MockBuilder;
import org.kie.kogito.serverless.workflow.utils.ConfigResolver;
import org.kie.kogito.serverless.workflow.utils.ConfigResolverHolder;
import org.mockito.Mockito;

class JqExpressionHandlerTest {
    JqExpressionHandlerTest() {
    }

    @BeforeAll
    public static void setConfigResolver() {
        final HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("lettersonly", "secretlettersonly");
        configMap.put("dot.secret", "secretdotsecret");
        configMap.put("dash-secret", "secretdashsecret");
        ConfigResolverHolder.setConfigResolver((ConfigResolver)new ConfigResolver(){

            public <T> Optional<T> getConfigProperty(String name, Class<T> clazz) {
                return Optional.ofNullable(configMap.get(name));
            }
        });
    }

    @Test
    void testStringExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyString");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals((Object)"string", (Object)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), String.class, JqExpressionHandlerTest.getContext()));
    }

    @Test
    void testBooleanExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyBoolean");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertTrue((boolean)((Boolean)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), Boolean.class, JqExpressionHandlerTest.getContext())));
    }

    @Test
    void testNumericExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyNum*.propertyNum");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals((int)144, (int)((JsonNode)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), JsonNode.class, JqExpressionHandlerTest.getContext())).asInt());
    }

    @Test
    void testNumericAssignment() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)"{\"result\" : .propertyNum*.propertyNum}");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals((int)144, (int)((JsonNode)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), JsonNode.class, JqExpressionHandlerTest.getContext())).get("result").asInt());
    }

    @Test
    void testJsonNodeExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".nested");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals((Object)"value1", (Object)((ObjectNode)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), ObjectNode.class, JqExpressionHandlerTest.getContext())).get("property1").asText());
    }

    @Test
    void testMultiExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyString,.propertyNum,.propertyBoolean");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals((Object)"string 12 true", (Object)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), String.class, JqExpressionHandlerTest.getContext()));
    }

    @Test
    void testMultiExpressionAsCollection() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyString,.propertyNum,.propertyBoolean");
        Assertions.assertEquals(Arrays.asList("string", 12, true), (Object)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), Collection.class, JqExpressionHandlerTest.getContext()));
    }

    @Test
    void testCollection() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".arrayMixed");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals(Arrays.asList("string1", 12, false, Arrays.asList(1.1, 1.2, 1.3)), (Object)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), Collection.class, JqExpressionHandlerTest.getContext()));
    }

    @Test
    void testCollectFromArrayJsonNode() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".arrayOfObjects | .[] | .property1");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        JsonNode eval = (JsonNode)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), JsonNode.class, JqExpressionHandlerTest.getContext());
        Assertions.assertTrue((boolean)eval.isArray(), (String)"Expected array as a result.");
        Assertions.assertEquals((int)3, (int)eval.size(), (String)"Unexpected size of the array.");
        Assertions.assertEquals((Object)"p1-value1", (Object)eval.get(0).asText(), (String)"Unexpected value in array at index 0.");
        Assertions.assertEquals((Object)"p1-value2", (Object)eval.get(1).asText(), (String)"Unexpected value in array at index 1.");
        Assertions.assertEquals((Object)"p1-value3", (Object)eval.get(2).asText(), (String)"Unexpected value in array at index 2.");
    }

    @Test
    void testCollectFromArrayCollection() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".arrayOfObjects | .[] | .property1");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals(Arrays.asList("p1-value1", "p1-value2", "p1-value3"), (Object)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), Collection.class, JqExpressionHandlerTest.getContext()), (String)"Unexpected contents of the collected values.");
    }

    @Test
    void testCollectFromArrayCollectionRecursive() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)"..|.property1?//empty");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals(Arrays.asList("value1", "p1-value1", "p1-value2", "p1-value3", "accessible_value1", "accessible_value2", "accessible_value3"), (Object)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), Collection.class, JqExpressionHandlerTest.getContext()));
    }

    @Test
    void testNonValidExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".-");
        Assertions.assertEquals((Object)false, (Object)parsedExpression.isValid(), (String)"Exception was not thrown for invalid expression.");
    }

    @Test
    void testNonMatchingExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".foo | .bar");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.putArray("foo").add((JsonNode)objectMapper.createArrayNode().add((JsonNode)objectMapper.createObjectNode().put("bar", "1")).add((JsonNode)objectMapper.createObjectNode().put("bar", "2")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> parsedExpression.eval((Object)objectNode, String.class, JqExpressionHandlerTest.getContext()), (String)"Exception expected for non-matched expression.");
    }

    @Test
    void testAssignSimpleObjectUnderGivenProperty() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyString");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode toBeInserted = objectMapper.createObjectNode();
        toBeInserted.put("bar", "value1");
        ObjectNode targetNode = JqExpressionHandlerTest.getObjectNode();
        parsedExpression.assign((Object)targetNode, (Object)toBeInserted, JqExpressionHandlerTest.getContext());
        Assertions.assertFalse((boolean)targetNode.has("bar"), (String)"Property 'bar' should not be in root.");
        Assertions.assertTrue((boolean)targetNode.has("propertyString"), (String)"Property 'propertyString' is missing in root.");
        Assertions.assertTrue((boolean)targetNode.get("propertyString").has("bar"), (String)"Property 'propertyString' should contain 'bar'.");
        Assertions.assertEquals((Object)"value1", (Object)targetNode.get("propertyString").get("bar").asText(), (String)"Unexpected value under 'propertyString'->'bar' property.");
    }

    @Test
    void testAssignArrayUnderGivenProperty() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyString");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode toBeInserted = objectMapper.createObjectNode();
        toBeInserted.putArray("bar").add("value1").add("value2");
        ObjectNode targetNode = JqExpressionHandlerTest.getObjectNode();
        parsedExpression.assign((Object)targetNode, (Object)toBeInserted, JqExpressionHandlerTest.getContext());
        Assertions.assertFalse((boolean)targetNode.has("bar"), (String)"Property 'bar' should not be in root.");
        Assertions.assertTrue((boolean)targetNode.has("propertyString"), (String)"Property 'propertyString' was removed.");
        Assertions.assertTrue((boolean)targetNode.get("propertyString").has("bar"), (String)"Property 'bar' is not under 'propertyString'.");
        Assertions.assertTrue((boolean)targetNode.get("propertyString").get("bar").isArray(), (String)"Property 'bar' is not an array.");
        Assertions.assertEquals((int)2, (int)targetNode.get("propertyString").get("bar").size(), (String)"'bar' array has unexpected size");
        Assertions.assertEquals((Object)"value1", (Object)targetNode.get("propertyString").get("bar").get(0).asText(), (String)"Unexpected value in 'bar' array at index 0.");
        Assertions.assertEquals((Object)"value2", (Object)targetNode.get("propertyString").get("bar").get(1).asText(), (String)"Unexpected value in 'bar' array at index 1.");
    }

    @Test
    void testAssignCollectedFromArrayUnderRootAsFallback() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".arrayOfNestedObjects | .[] | .nested");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode targetNode = JqExpressionHandlerTest.getObjectNode();
        ObjectNode toBeInserted = objectMapper.createObjectNode().put("propertyNum", 4);
        parsedExpression.assign((Object)targetNode, (Object)toBeInserted, JqExpressionHandlerTest.getContext());
        Assertions.assertTrue((boolean)targetNode.has("nested"), (String)"A new property 'nested' should have been added at root as a fallback.");
        Assertions.assertTrue((boolean)targetNode.get("nested").isArray(), (String)"Property 'nested' should contain array");
        Assertions.assertEquals((int)4, (int)targetNode.get("nested").size(), (String)"'nested' array length mismatch.");
        Assertions.assertEquals((int)1, (int)targetNode.get("nested").get(0).get("propertyNum").asInt(), (String)"Unexpected value in 'nested' array at index 0.");
        Assertions.assertEquals((int)2, (int)targetNode.get("nested").get(1).get("propertyNum").asInt(), (String)"Unexpected value in 'nested' array at index 1.");
        Assertions.assertEquals((int)3, (int)targetNode.get("nested").get(2).get("propertyNum").asInt(), (String)"Unexpected value in 'nested' array at index 2.");
        Assertions.assertEquals((int)4, (int)targetNode.get("nested").get(3).get("propertyNum").asInt(), (String)"Unexpected value in 'nested' array at index 3.");
    }

    @Test
    void testAssignWithNonExistentNodePathExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".property3");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode toBeInserted = objectMapper.createObjectNode();
        toBeInserted.put("property1", "value1");
        ObjectNode targetNode = objectMapper.createObjectNode();
        targetNode.put("property2", "value2");
        parsedExpression.assign((Object)targetNode, (Object)toBeInserted, JqExpressionHandlerTest.getContext());
        Assertions.assertFalse((boolean)targetNode.has("property1"), (String)"Property 'property1' should not be in root.");
        Assertions.assertTrue((boolean)targetNode.has("property2"), (String)"Property 'property2' is missing in root.");
        Assertions.assertTrue((boolean)targetNode.has("property3"), (String)"Property 'property3' is missing in root.");
        Assertions.assertTrue((boolean)targetNode.get("property3").has("property1"), (String)"Property 'property3' should contain 'property1'.");
        Assertions.assertEquals((Object)"value1", (Object)targetNode.get("property3").get("property1").asText(), (String)"Unexpected value under 'property3'->'property1' property.");
    }

    @Test
    void testMagicWord() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)"$WORKFLOW.instanceId");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals((Object)new TextNode("1111-2222-3333"), (Object)parsedExpression.eval((Object)ObjectMapperFactory.get().createObjectNode(), JsonNode.class, JqExpressionHandlerTest.getContext()));
    }

    @Test
    void testConstPropertyFromJsonAccessible() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".CONST.property1");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals((Object)"accessible_value1", (Object)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), String.class, JqExpressionHandlerTest.getContext()));
    }

    @Test
    void testSecretPropertyFromJsonAccessible() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".SECRET.property1");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals((Object)"accessible_value2", (Object)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), String.class, JqExpressionHandlerTest.getContext()));
    }

    @Test
    void testWorkflowPropertyFromJsonAccessible() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".WORKFLOW.property1");
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals((Object)"accessible_value3", (Object)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), String.class, JqExpressionHandlerTest.getContext()));
    }

    @ParameterizedTest(name="{index} \"{0}\" is resolved to \"{1}\"")
    @MethodSource(value={"provideMagicWordExpressionsToTest"})
    void testMagicWordsExpressions(String expression, String expectedResult, KogitoProcessContext context) {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)expression);
        Assertions.assertTrue((boolean)parsedExpression.isValid());
        Assertions.assertEquals((Object)expectedResult, (Object)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), String.class, context));
    }

    private static Stream<Arguments> provideMagicWordExpressionsToTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{"$WORKFLOW.instanceId", "1111-2222-3333", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"\"WORKFLOW.instanceId\"", "WORKFLOW.instanceId", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"\"$WORKFLOW.instanceId\"", "$WORKFLOW.instanceId", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"\"$WORKFLOW.instanceId: \" + $WORKFLOW.instanceId", "$WORKFLOW.instanceId: 1111-2222-3333", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$SECRET.none", "null", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"\"$SECRET.none\"", "$SECRET.none", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$SECRET.lettersonly", "secretlettersonly", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$SECRET.dot.secret", "null", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$SECRET.\"dot.secret\"", "secretdotsecret", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$SECRET.\"dash-secret\"", "secretdashsecret", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$CONST.someconstant", "value", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$CONST.\"someconstant\"", "value", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$CONST.some.constant", "null", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$CONST.\"some.constant\"", "value", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$CONST.\"some-constant\"", "value", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$CONST.injectedexpression", "$WORKFLOW.instanceId", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{".arrayOfObjects | .[] | select(.property1 == \"p1-value1\") | .property1", "p1-value1", JqExpressionHandlerTest.getContext()}));
    }

    private static KogitoProcessContext getContext() {
        return MockBuilder.kogitoProcessContext().withProcessInstanceMock(p -> Mockito.when((Object)p.getId()).thenReturn((Object)"1111-2222-3333")).withConstants(Collections.singletonMap("someconstant", "value")).withConstants(Collections.singletonMap("some.constant", "value")).withConstants(Collections.singletonMap("some-constant", "value")).withConstants(Collections.singletonMap("injectedexpression", "$WORKFLOW.instanceId")).build();
    }

    private static ObjectNode getObjectNode() {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("propertyString", "string").put("propertyNum", 12).put("propertyBoolean", true);
        objectNode.putObject("nested").put("property1", "value1");
        objectNode.putArray("arrayOfObjects").add((JsonNode)objectMapper.createObjectNode().put("property1", "p1-value1")).add((JsonNode)objectMapper.createObjectNode().put("property1", "p1-value2")).add((JsonNode)objectMapper.createObjectNode().put("property1", "p1-value3"));
        objectNode.putArray("arrayOfNestedObjects").add(objectMapper.createObjectNode().set("nested", (JsonNode)objectMapper.createObjectNode().put("propertyNum", 1))).add(objectMapper.createObjectNode().set("nested", (JsonNode)objectMapper.createObjectNode().put("propertyNum", 2))).add(objectMapper.createObjectNode().set("nested", (JsonNode)objectMapper.createObjectNode().put("propertyNum", 3)));
        objectNode.putArray("arrayOfStrings").add("string1").add("string2").add("string3");
        objectNode.putArray("arrayOfNums").add(1).add(2).add(3);
        objectNode.putArray("arrayMixed").add("string1").add(12).add(false).add((JsonNode)objectMapper.createArrayNode().add(1.1).add(1.2).add(1.3));
        objectNode.putObject("CONST").put("property1", "accessible_value1");
        objectNode.putObject("SECRET").put("property1", "accessible_value2");
        objectNode.putObject("WORKFLOW").put("property1", "accessible_value3");
        return objectNode;
    }
}

