/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jq;

import java.util.function.Supplier;
import net.thisptr.jackson.jq.BuiltinFunctionLoader;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Versions;
import org.kie.kogito.expr.jq.JqExpression;
import org.kie.kogito.process.expr.Expression;
import org.kie.kogito.serverless.workflow.utils.CachedExpressionHandler;
import org.slf4j.LoggerFactory;

public class JqExpressionHandler
extends CachedExpressionHandler {
    private static Supplier<Scope> scopeSupplier = new DefaultScopeSupplier();

    public static void setScopeSupplier(Supplier<Scope> scopeSupplier) {
        JqExpressionHandler.scopeSupplier = scopeSupplier;
    }

    public Expression buildExpression(String expr) {
        return new JqExpression(scopeSupplier, expr);
    }

    public String lang() {
        return "jq";
    }

    private static class DefaultScopeSupplier
    implements Supplier<Scope> {
        private DefaultScopeSupplier() {
        }

        @Override
        public Scope get() {
            return DefaultScope.scope;
        }

        private static class DefaultScope {
            private static Scope scope;

            private DefaultScope() {
            }

            static {
                LoggerFactory.getLogger(JqExpressionHandler.class).info("Using default scope");
                scope = Scope.newEmptyScope();
                BuiltinFunctionLoader.getInstance().loadFunctions(Versions.JQ_1_6, scope);
            }
        }
    }
}

