/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.expr.jq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.process.expr.Expression;
import org.kie.kogito.process.expr.ExpressionHandlerFactory;
import org.kie.kogito.serverless.workflow.test.MockBuilder;
import org.kie.kogito.serverless.workflow.utils.ConfigResolver;
import org.kie.kogito.serverless.workflow.utils.ConfigResolverHolder;
import org.mockito.Mockito;

class JqExpressionHandlerTest {
    JqExpressionHandlerTest() {
    }

    @BeforeAll
    public static void setConfigResolver() {
        final HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("lettersonly", "secretlettersonly");
        configMap.put("dot.secret", "secretdotsecret");
        configMap.put("dash-secret", "secretdashsecret");
        ConfigResolverHolder.setConfigResolver((ConfigResolver)new ConfigResolver(){

            public <T> Optional<T> getConfigProperty(String name, Class<T> clazz) {
                return Optional.ofNullable(configMap.get(name));
            }
        });
    }

    @Test
    void testStringExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyString");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((String)((String)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), String.class, JqExpressionHandlerTest.getContext()))).isEqualTo("string");
    }

    @Test
    void testBooleanExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyBoolean");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((Boolean)((Boolean)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), Boolean.class, JqExpressionHandlerTest.getContext()))).isTrue();
    }

    @Test
    void testNumericExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyNum*.propertyNum");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((int)((JsonNode)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), JsonNode.class, JqExpressionHandlerTest.getContext())).asInt()).isEqualTo(144);
    }

    @Test
    void testNumericAssignment() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)"{\"result\" : .propertyNum*.propertyNum}");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((int)((JsonNode)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), JsonNode.class, JqExpressionHandlerTest.getContext())).get("result").asInt()).isEqualTo(144);
    }

    @Test
    void testJsonNodeExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".nested");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((String)((ObjectNode)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), ObjectNode.class, JqExpressionHandlerTest.getContext())).get("property1").asText()).isEqualTo("value1");
    }

    @Test
    void testMultiExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyString,.propertyNum,.propertyBoolean");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((String)((String)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), String.class, JqExpressionHandlerTest.getContext()))).isEqualTo("string 12 true");
    }

    @Test
    void testMultiExpressionAsCollection() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyString,.propertyNum,.propertyBoolean");
        Assertions.assertThat((Collection)((Collection)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), Collection.class, JqExpressionHandlerTest.getContext()))).containsExactly(new Object[]{"string", 12, true});
    }

    @Test
    void testCollection() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".arrayMixed");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((Collection)((Collection)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), Collection.class, JqExpressionHandlerTest.getContext()))).containsExactly(new Object[]{"string1", 12, false, Arrays.asList(1.1, 1.2, 1.3)});
    }

    @Test
    void testCollectFromArrayJsonNode() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".arrayOfObjects | .[] | .property1");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        JsonNode eval = (JsonNode)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), JsonNode.class, JqExpressionHandlerTest.getContext());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)eval.isArray()).as("Expected array as a result.", new Object[0])).isTrue();
        ((IterableAssert)Assertions.assertThat((Iterable)eval).as("Unexpected size of the array.", new Object[0])).hasSize(3);
        ((AbstractStringAssert)Assertions.assertThat((String)eval.get(0).asText()).as("Unexpected value in array at index 0.", new Object[0])).isEqualTo("p1-value1");
        ((AbstractStringAssert)Assertions.assertThat((String)eval.get(1).asText()).as("Unexpected value in array at index 1.", new Object[0])).isEqualTo("p1-value2");
        ((AbstractStringAssert)Assertions.assertThat((String)eval.get(2).asText()).as("Unexpected value in array at index 2.", new Object[0])).isEqualTo("p1-value3");
    }

    @Test
    void testCollectFromArrayCollection() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".arrayOfObjects | .[] | .property1");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((Collection)((Collection)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), Collection.class, JqExpressionHandlerTest.getContext()))).as("Unexpected contents of the collected values.", new Object[0]).containsExactly(new Object[]{"p1-value1", "p1-value2", "p1-value3"});
    }

    @Test
    void testCollectFromArrayCollectionRecursive() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)"..|.property1?//empty");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((Collection)((Collection)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), Collection.class, JqExpressionHandlerTest.getContext()))).isEqualTo(Arrays.asList("value1", "p1-value1", "p1-value2", "p1-value3", "accessible_value1", "accessible_value2", "accessible_value3"));
    }

    @Test
    void testNonValidExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".-");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)parsedExpression.isValid()).as("Exception was not thrown for invalid expression.", new Object[0])).isFalse();
    }

    @Test
    void testNonMatchingExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".foo | .bar");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.putArray("foo").add((JsonNode)objectMapper.createArrayNode().add((JsonNode)objectMapper.createObjectNode().put("bar", "1")).add((JsonNode)objectMapper.createObjectNode().put("bar", "2")));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> parsedExpression.eval((Object)objectNode, String.class, JqExpressionHandlerTest.getContext()), (String)"Exception expected for non-matched expression.");
    }

    @Test
    void testAssignSimpleObjectUnderGivenProperty() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyString");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode toBeInserted = objectMapper.createObjectNode();
        toBeInserted.put("bar", "value1");
        ObjectNode targetNode = JqExpressionHandlerTest.getObjectNode();
        parsedExpression.assign((Object)targetNode, (Object)toBeInserted, JqExpressionHandlerTest.getContext());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.has("bar")).as("Property 'bar' should not be in root.", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.has("propertyString")).as("Property 'propertyString' is missing in root.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.get("propertyString").has("bar")).as("Property 'propertyString' should contain 'bar'.", new Object[0])).isTrue();
        ((AbstractStringAssert)Assertions.assertThat((String)targetNode.get("propertyString").get("bar").asText()).as("Unexpected value under 'propertyString'->'bar' property.", new Object[0])).isEqualTo("value1");
    }

    @Test
    void testAssignArrayUnderGivenProperty() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".propertyString");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode toBeInserted = objectMapper.createObjectNode();
        toBeInserted.putArray("bar").add("value1").add("value2");
        ObjectNode targetNode = JqExpressionHandlerTest.getObjectNode();
        parsedExpression.assign((Object)targetNode, (Object)toBeInserted, JqExpressionHandlerTest.getContext());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.has("bar")).as("Property 'bar' should not be in root.", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.has("propertyString")).as("Property 'propertyString' was removed.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.get("propertyString").has("bar")).as("Property 'bar' is not under 'propertyString'.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.get("propertyString").get("bar").isArray()).as("Property 'bar' is not an array.", new Object[0])).isTrue();
        ((IterableAssert)Assertions.assertThat((Iterable)targetNode.get("propertyString").get("bar")).as("'bar' array has unexpected size", new Object[0])).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)targetNode.get("propertyString").get("bar").get(0).asText()).as("Unexpected value in 'bar' array at index 0.", new Object[0])).isEqualTo("value1");
        ((AbstractStringAssert)Assertions.assertThat((String)targetNode.get("propertyString").get("bar").get(1).asText()).as("Unexpected value in 'bar' array at index 1.", new Object[0])).isEqualTo("value2");
    }

    @Test
    void testAssignCollectedFromArrayUnderRootAsFallback() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".arrayOfNestedObjects | .[] | .nested");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode targetNode = JqExpressionHandlerTest.getObjectNode();
        ObjectNode toBeInserted = objectMapper.createObjectNode().put("propertyNum", 4);
        parsedExpression.assign((Object)targetNode, (Object)toBeInserted, JqExpressionHandlerTest.getContext());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.has("nested")).as("A new property 'nested' should have been added at root as a fallback.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.get("nested").isArray()).as("Property 'nested' should contain array", new Object[0])).isTrue();
        ((IterableAssert)Assertions.assertThat((Iterable)targetNode.get("nested")).as("'nested' array length mismatch.", new Object[0])).hasSize(4);
        ((AbstractIntegerAssert)Assertions.assertThat((int)targetNode.get("nested").get(0).get("propertyNum").asInt()).as("Unexpected value in 'nested' array at index 0.", new Object[0])).isEqualTo(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)targetNode.get("nested").get(1).get("propertyNum").asInt()).as("Unexpected value in 'nested' array at index 1.", new Object[0])).isEqualTo(2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)targetNode.get("nested").get(2).get("propertyNum").asInt()).as("Unexpected value in 'nested' array at index 2.", new Object[0])).isEqualTo(3);
        ((AbstractIntegerAssert)Assertions.assertThat((int)targetNode.get("nested").get(3).get("propertyNum").asInt()).as("Unexpected value in 'nested' array at index 3.", new Object[0])).isEqualTo(4);
    }

    @Test
    void testAssignWithNonExistentNodePathExpression() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".property3");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode toBeInserted = objectMapper.createObjectNode();
        toBeInserted.put("property1", "value1");
        ObjectNode targetNode = objectMapper.createObjectNode();
        targetNode.put("property2", "value2");
        parsedExpression.assign((Object)targetNode, (Object)toBeInserted, JqExpressionHandlerTest.getContext());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.has("property1")).as("Property 'property1' should not be in root.", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.has("property2")).as("Property 'property2' is missing in root.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.has("property3")).as("Property 'property3' is missing in root.", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)targetNode.get("property3").has("property1")).as("Property 'property3' should contain 'property1'.", new Object[0])).isTrue();
        ((AbstractStringAssert)Assertions.assertThat((String)targetNode.get("property3").get("property1").asText()).as("Unexpected value under 'property3'->'property1' property.", new Object[0])).isEqualTo("value1");
    }

    @Test
    void testMagicWord() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)"$WORKFLOW.instanceId");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((Iterable)((Iterable)parsedExpression.eval((Object)ObjectMapperFactory.get().createObjectNode(), JsonNode.class, JqExpressionHandlerTest.getContext()))).isEqualTo((Object)new TextNode("1111-2222-3333"));
    }

    @Test
    void testConstPropertyFromJsonAccessible() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".CONST.property1");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((String)((String)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), String.class, JqExpressionHandlerTest.getContext()))).isEqualTo("accessible_value1");
    }

    @Test
    void testSecretPropertyFromJsonAccessible() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".SECRET.property1");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((String)((String)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), String.class, JqExpressionHandlerTest.getContext()))).isEqualTo("accessible_value2");
    }

    @Test
    void testWorkflowPropertyFromJsonAccessible() {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)".WORKFLOW.property1");
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((String)((String)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), String.class, JqExpressionHandlerTest.getContext()))).isEqualTo("accessible_value3");
    }

    @ParameterizedTest(name="{index} \"{0}\" is resolved to \"{1}\"")
    @MethodSource(value={"provideMagicWordExpressionsToTest"})
    void testMagicWordsExpressions(String expression, String expectedResult, KogitoProcessContext context) {
        Expression parsedExpression = ExpressionHandlerFactory.get((String)"jq", (String)expression);
        Assertions.assertThat((boolean)parsedExpression.isValid()).isTrue();
        Assertions.assertThat((String)((String)parsedExpression.eval((Object)JqExpressionHandlerTest.getObjectNode(), String.class, context))).isEqualTo(expectedResult);
    }

    private static Stream<Arguments> provideMagicWordExpressionsToTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{"$WORKFLOW.instanceId", "1111-2222-3333", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"\"WORKFLOW.instanceId\"", "WORKFLOW.instanceId", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"\"$WORKFLOW.instanceId\"", "$WORKFLOW.instanceId", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"\"$WORKFLOW.instanceId: \" + $WORKFLOW.instanceId", "$WORKFLOW.instanceId: 1111-2222-3333", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$SECRET.none", "null", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"\"$SECRET.none\"", "$SECRET.none", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$SECRET.lettersonly", "secretlettersonly", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$SECRET.dot.secret", "null", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$SECRET.\"dot.secret\"", "secretdotsecret", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$SECRET.\"dash-secret\"", "secretdashsecret", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$CONST.someconstant", "value", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$CONST.\"someconstant\"", "value", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$CONST.some.constant", "null", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$CONST.\"some.constant\"", "value", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$CONST.\"some-constant\"", "value", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{"$CONST.injectedexpression", "$WORKFLOW.instanceId", JqExpressionHandlerTest.getContext()}), Arguments.of((Object[])new Object[]{".arrayOfObjects | .[] | select(.property1 == \"p1-value1\") | .property1", "p1-value1", JqExpressionHandlerTest.getContext()}));
    }

    private static KogitoProcessContext getContext() {
        return MockBuilder.kogitoProcessContext().withProcessInstanceMock(p -> Mockito.when((Object)p.getId()).thenReturn((Object)"1111-2222-3333")).withConstants(Collections.singletonMap("someconstant", "value")).withConstants(Collections.singletonMap("some.constant", "value")).withConstants(Collections.singletonMap("some-constant", "value")).withConstants(Collections.singletonMap("injectedexpression", "$WORKFLOW.instanceId")).build();
    }

    private static ObjectNode getObjectNode() {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("propertyString", "string").put("propertyNum", 12).put("propertyBoolean", true);
        objectNode.putObject("nested").put("property1", "value1");
        objectNode.putArray("arrayOfObjects").add((JsonNode)objectMapper.createObjectNode().put("property1", "p1-value1")).add((JsonNode)objectMapper.createObjectNode().put("property1", "p1-value2")).add((JsonNode)objectMapper.createObjectNode().put("property1", "p1-value3"));
        objectNode.putArray("arrayOfNestedObjects").add(objectMapper.createObjectNode().set("nested", (JsonNode)objectMapper.createObjectNode().put("propertyNum", 1))).add(objectMapper.createObjectNode().set("nested", (JsonNode)objectMapper.createObjectNode().put("propertyNum", 2))).add(objectMapper.createObjectNode().set("nested", (JsonNode)objectMapper.createObjectNode().put("propertyNum", 3)));
        objectNode.putArray("arrayOfStrings").add("string1").add("string2").add("string3");
        objectNode.putArray("arrayOfNums").add(1).add(2).add(3);
        objectNode.putArray("arrayMixed").add("string1").add(12).add(false).add((JsonNode)objectMapper.createArrayNode().add(1.1).add(1.2).add(1.3));
        objectNode.putObject("CONST").put("property1", "accessible_value1");
        objectNode.putObject("SECRET").put("property1", "accessible_value2");
        objectNode.putObject("WORKFLOW").put("property1", "accessible_value3");
        return objectNode;
    }
}

