/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.decisions.hotreload;

import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.function.Supplier;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class SimpleModifyHotReloadIT {
    private static final String PACKAGE = "org.kie.kogito.quarkus.decisions.hotreload";
    private static final String RESOURCE_FILE_PATH;
    private static final String DMN_RESOURCE_FILE;
    private static final String HTTP_TEST_PORT = "65535";
    @RegisterExtension
    static final QuarkusDevModeTest test;

    @Test
    void simpleHotReloadTest() throws InterruptedException {
        this.executeTest("No");
        test.modifyResourceFile(DMN_RESOURCE_FILE, s -> s.replaceAll("if Total Points >= 20 then \"Yes\" else \"No\"", "if Total Points >= 2 then \"Yes\" else \"No\""));
        this.executeTest("Yes");
        test.modifyResourceFile(DMN_RESOURCE_FILE, s -> s.replaceAll("if Total Points >= 2 then \"Yes\" else \"No\"", "if Total Points >= 20 then \"Yes\" else \"No\""));
        this.executeTest("No");
    }

    private void executeTest(String result) {
        ValidatableResponse response = (ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:65535").contentType(ContentType.JSON).accept(ContentType.JSON).body("{\n    \"Driver\": {\n        \"Points\": 2\n    },\n    \"Violation\": {\n        \"Type\": \"speed\",\n        \"Actual Speed\": 120,\n        \"Speed Limit\": 100\n    }\n}").contentType(ContentType.JSON).when().post("/Traffic Violation", new Object[0])).then();
        ((ValidatableResponse)response.statusCode(200)).body("'Should the driver be suspended?'", Matchers.is((Object)result), new Object[0]);
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        RESOURCE_FILE_PATH = PACKAGE.replace('.', '/');
        DMN_RESOURCE_FILE = RESOURCE_FILE_PATH + "/TrafficViolation.dmn";
        test = new QuarkusDevModeTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive ja = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource("application.properties.stronglytyped", "/application.properties")).addAsResource("TrafficViolation.txt", DMN_RESOURCE_FILE);
                return ja;
            }
        });
    }
}

