/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.decisions.hotreload;

import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class SimpleHotReloadIT {
    private static final String PACKAGE = "org.kie.kogito.quarkus.decisions.hotreload";
    private static final String RESOURCE_FILE_PATH;
    private static final String DMN_RESOURCE_FILE;
    @RegisterExtension
    static final QuarkusDevModeTest test;

    @Test
    void simpleHotReloadTest() throws InterruptedException {
        this.executeTest("Traffic Violation");
        test.modifyResourceFile(DMN_RESOURCE_FILE, s -> s.replaceAll("Traffic", "NewTraffic"));
        this.executeTest("NewTraffic Violation");
    }

    private void executeTest(String path) {
        String httpPort = (String)ConfigProvider.getConfig().getValue("quarkus.http.port", String.class);
        ValidatableResponse response = (ValidatableResponse)((Response)RestAssured.given().baseUri("http://localhost:" + httpPort).contentType(ContentType.JSON).accept(ContentType.JSON).body("{\n    \"Driver\": {\n        \"Points\": 2\n    },\n    \"Violation\": {\n        \"Type\": \"speed\",\n        \"Actual Speed\": 120,\n        \"Speed Limit\": 100\n    }\n}").contentType(ContentType.JSON).when().post("/" + path, new Object[0])).then();
        ((ValidatableResponse)response.statusCode(200)).body("'Should the driver be suspended?'", Matchers.is((Object)"No"), new Object[0]);
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        RESOURCE_FILE_PATH = PACKAGE.replace('.', '/');
        DMN_RESOURCE_FILE = RESOURCE_FILE_PATH + "/TrafficViolation.dmn";
        test = new QuarkusDevModeTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource("TrafficViolation.txt", DMN_RESOURCE_FILE));
    }
}

